<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

//On theme activation add defaults theme settings and data
add_action( 'after_setup_theme', 'NewsStreet_default_theme_options_setup' );

function NewsStreet_default_theme_options_setup() {
	// News Blog Template Images
	add_image_size( 'crypto-news-blog', '700', '535', true);
}

if ( !function_exists( 'newsstreet_chld_thm_cfg_parent_css' ) ):
	function newsstreet_chld_thm_cfg_parent_css() {
		// cryptocurrency exchange parent style css
		wp_enqueue_style('newsstreet-parent-style', trailingslashit( get_template_directory_uri() ) . 'style.css', array( 'bootstrap-min-css','cryptocurrency-exchange-animate-css','font-awesome-min-css','crypto-flexslider-css' ));

		// newsstreet style css
		wp_enqueue_style('newsstreet-child-style', get_stylesheet_directory_uri() . '/style.css', array('parent-style'));

		// newsstreet custom color style css
		wp_enqueue_style('newsstreet-custom-color', get_stylesheet_directory_uri() . '/css/newsstreet-custom-color.css', array('crypto-custom-color'));
	}
endif;
add_action( 'wp_enqueue_scripts', 'newsstreet_chld_thm_cfg_parent_css', 10 );
// END ENQUEUE PARENT ACTION

function newsstreet_customize_register() {
	global $wp_customize;
	$wp_customize->remove_section( 'upgrade_crypto_premium' );  //Modify this line as needed
	$wp_customize->remove_section( 'cryptocurrency_slider_option' );  //Modify this line as needed
	$wp_customize->remove_section( 'cryptocurrency_service_option' );  //Modify this line as needed
	$wp_customize->remove_section( 'cryptocurrency_exchange_blog_option' );  //Modify this line as needed
	$wp_customize->remove_section( 'cryptocurrency_portfolio_section' );  //Modify this line as needed
	$wp_customize->remove_section( 'cryptocurrency_exchange_testimonial_settings' ); //Modify this line as needed
	
	//NewsBlog Customiser Section
	$wp_customize->add_section( 'newsstreet_newsblog_option' , array(
			'title'      	=> __( 'News Blog', 'newsstreet' ),
			'description'   => __('Newsstreet has very elegant design of showing blog post.', 'newsstreet'),
			'priority'      => 4,
			'panel'      	=> 'cryptocurrency_exchange_theme_options',
		) 
	);
	
	//NewsBlog Default Setting
	$wp_customize->add_setting( 'newsstreet_newsblog_setting', array(
			'default'      		=> 'inactive',
			'sanitize_callback' => 'cryptocurrency_exchange_sanitize_radio'
		)
	);
	
	//NewsBlog Customiser Section's Control
	$wp_customize->add_control('newsstreet_newsblog_setting', array(
			'type'      => 'radio',
			'label'     => __('News Blog Design', 'newsstreet'),
			'section'   => 'newsstreet_newsblog_option',
			'priority'  => 1,
			'choices'   => array(
				'active'       => __( 'Active', 'newsstreet' ),
				'inactive'     => __( 'Inactive', 'newsstreet' ),
			),
		)
	);
}
add_action( 'customize_register', 'newsstreet_customize_register', 11 );
// END ENQUEUE PARENT ACTION