<?php
/**
 * Created by PhpStorm.
 * User: dell
 * Date: 5/31/2018
 * Time: 10:23 PM
 */

if (!class_exists('newsmania_cat_widget')) {
    class newsmania_cat_widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'newsmania_cat_widget',
                esc_html__(' Newsmania_Category', 'newsmania'),
                array('description' => esc_html__('Show category',
                    'newsmania'))
            );
        }

        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['Title'])) {
                echo $args['before_title'] . apply_filters('widget_title', $instance['Title'], $instance, $this->id_base) . $args['after_title'];

            } ?>
            <div class="body">
                <ul class="sidebar-category fashion-category">
                    <?php
                    $cats = get_categories();
                    foreach ($cats as $cat) {
                        ?>

                        <li><a href="<?php echo esc_url(get_category_link($cat)) ?>"><?php echo $cat->cat_name; ?>
                                <span class="badge bg-sports pull-right"><?php echo $cat->count; ?></span>
                            </a>
                        </li>
                        <?php
                    } ?>
                </ul>
            </div>

            <?php
            echo $args['after_widget'];
        }

        public function form($instance)
        {
            $Title = !empty($instance['Title']) ? $instance['Title'] : esc_html__('POPULAR CATEGORIES', 'newsmania'); ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('Title')); ?>">
                    <?php esc_html_e('Title :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('Title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('Title')); ?>" type="text"
                       value="<?php echo esc_attr($Title); ?>">
            </p>
        <?php }

        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['Title'] = (!empty($new_instance['Title'])) ? strip_tags($new_instance['Title']) : esc_html__('POPULAR CATEGORIES', 'newsmania');;

            return $instance;
        }
    }

    add_action('widgets_init', 'wid1_register_widget');
    function wid1_register_widget()
    {
        register_widget("newsmania_cat_widget");

    }
}
?>