<?php

class  Elementor_custom_title_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'title_widget';
    }

    public function get_title()
    {
        return __('Newsmania Title', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-type-tool';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'title',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $custom = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo $custom; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo $custom; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }
        </style>

        <div class="head">
            <!-- Title -->
            <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
        </div><!-- Post Block Head End -->
        <div class="simple-line line-video <?php echo $custom;?>"></div>


    <?php
    }
} ?>