<?php

class Elementor_slider_2_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'slider_2';
    }

    public function get_title()
    {
        return __('Recent Post Grid', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $cats = get_categories();
        $arr1 = array();
        foreach ($cats as $cat) {
            $arr1[$cat->cat_ID] = $cat->cat_name;
        }
        $this->add_control(
            'selectcat',
            array(
                'label' => __('Select Categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $arr1
            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
        <!-- Hero Section Start -->
        <div class="hero-section section overlay-opacity-10 pt-1 pb-1 fix">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="row row-3">
                            <?php
                            $arr = array('posts_per_page' => 4,
                                'category__in' => $settings['selectcat']);
                            $posts = new WP_Query($arr);
                            if ($posts->have_posts()) {
                                $i = 0;
                                while ($posts->have_posts()) {
                                    $posts->the_post();

                                    if ($i < 4) {
                                        ?>
                                        <div class="col-lg-3 col-12">
                                            <!-- Overlay Post Start -->
                                            <div class="post overlay hero-post pad">
                                                <div class="post-wrap">
                                                    <!-- Image -->
                                                    <div class="image">
                                                        <?php if (has_post_thumbnail()) { ?>
                                                            <?php the_post_thumbnail('newsmania-elementor-home3-slider'); ?>
                                                        <?php } else { ?>
                                                            <img
                                                                src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                        <?php } ?>
                                                    </div>
                                                    <!-- Content -->
                                                    <div class="content text-overlay">
                                                        <!-- Category -->
                                                        <?php
                                                        $cats = get_the_category();
                                                        echo '<a class="category fashion"
                                                     href="' . esc_url(get_category_link($cats[0])) . '">' .
                                                            $cats[0]->cat_name
                                                            . '</a> '; ?>
                                                        <!-- Title -->
                                                        <h4 class="title"><a
                                                                href="<?php the_permalink() ?>"><?php the_title(); ?></a>
                                                        </h4>
                                                        <!-- Meta -->
                                                        <div class="meta fix">
                                                                <span class="meta-item date"><i
                                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Overlay Post End -->
                                        </div>
                                    <?php
                                    }
                                    $i++;
                                }
                                wp_reset_postdata();
                            }?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Hero Section End -->
    <?php
    }
} ?>