<?php

class Elementor_cat_block_13_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return ' cat_block_13';
    }

    public function get_title()
    {
        return __('Categories Block 13', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no. of posts', 'newsmania'),
                'default' => '6',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );

        $cats = get_categories();
        $arr = array();
        foreach ($cats as $cat) {
            $arr[$cat->cat_ID] = $cat->cat_name;
        }

        $this->add_control(
            'selectcate',
            array(
                'label' => __('select categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT,

                'options' => $arr
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $ti_id = 'id-' . uniqid();?>
        <style>

            .simple-line.<?php echo $ti_id; ?> {
                border-bottom-color: <?php echo $settings['linecolor']?> !important;
            }

            .simple-line.<?php echo $ti_id; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post.life-style-post .content .title a.<?php echo $ti_id?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post .post-wrap .category.<?php echo $ti_id; ?> {
                background-color: <?php echo $settings['linecolor'];?>
            }

            .post .content .meta a.<?php echo $ti_id?>:hover {
                color: <?php echo $settings['linecolor'];?> !important;
            }
        </style>

        <!-- Post Section Start -->
        <div class="container">
            <!-- Cricket, Tennis & Motogp Post Row Start -->
            <div class="row">

                <!-- Post Block Wrapper Start -->
                <div class="post-block-wrapper">
                    <!-- Post Block Head Start -->
                    <div class="head">
                        <!-- Title -->
                        <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
                    </div>
                    <!-- Post Block Head End -->
                    <div class="simple-line line-life-style <?php echo $ti_id;?>"></div>
                    <!-- Post Block Body Start -->
                    <div class="body">
                        <?php
                        $post_ids = array();
                        $arr = array('posts_per_page' => $settings['number'],
                            'cat' => $settings['selectcate']);
                        $posts = new WP_Query($arr);
                        if ($posts->have_posts()) {
                            $i = 0;
                            while ($posts->have_posts()) {
                                $posts->the_post();
                                $post_ids[] = get_the_ID();
                                if ($i < $settings['number']) {
                                    if ($i == 0) {
                                        $a = "overlay life-style-post post-separator-border border-10";
                                    } else {
                                        $a = "life-style-post post-separator-border border-10";
                                    } ?>
                                    <div class="post <?php echo $a; ?>">
                                        <div class="post-wrap">

                                            <?php if ($i == 0) { ?>
                                                <a class="image"
                                                   href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>
                                                        <?php the_post_thumbnail('newsmania-elementor-home3-catpost'); ?>
                                                    <?php } else {
                                                        ?>
                                                        <img
                                                            src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                    <?php } ?></a>
                                            <?php } ?>
                                            <!-- Category -->

                                            <?php if ($i == 0) {
                                                $cats = get_the_category();
                                                echo '<a class="category education ' . $ti_id . '"
                                                     href="' . esc_url(get_category_link($cats[0])) . '">' .
                                                    $cats[0]->cat_name
                                                    . '</a> ';
                                            } ?>
                                            <!-- Content -->
                                            <div class="content mt-10">

                                                <!-- Title -->
                                                <h4 class="title light"><a class="<?php echo $ti_id ?>"
                                                                           href="<?php the_permalink() ?>"><?php the_title(); ?> </a>
                                                </h4>

                                                <!-- Meta -->
                                                <div class="meta fix">
                                                    <div class="meta-item">
                                                        <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                        <a class="<?php echo $ti_id ?>"
                                                           href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                           class="author"><?php the_author(); ?></a>
                                                    </div>
                                                    <div class="meta-item">
                                                        <i class="fa fa-clock-o"></i>
                                                        <span class="date"><?php the_time('j M, Y'); ?></span>
                                                    </div>
                                                </div>

                                            </div>

                                        </div>
                                    </div><!-- Post End -->
                                <?php
                                }
                                $i++;
                            }
                            wp_reset_postdata();
                        }?>
                    </div>
                    <!-- Post Block Body End -->
                </div>
                <!-- Post Block Wrapper End -->
            </div>
        </div>
    <?php
    }
} ?>