<?php
get_header();
?>
    <!-- Page Banner Section Start -->
    <div class="page-banner section">
        <div class="page-title-wrapper">
            <div class="container clearfix">
                <h2 class="pull-left title"><?php esc_html_e('404 Page Not Found', 'newsmania') ?></h2>
                <!-- breadcrumb -->
                <ol class="breadcrumb pull-right">
                    <li class="breadcrumb-item"><a
                            href="<?php echo esc_url(home_url('/')); ?>"><?php esc_html_e('Home', 'newsmania') ?></a>
                    </li>
                    <li class="breadcrumb-item active"><?php esc_html_e('404', 'newsmania') ?></li>
                </ol>
                <!-- //breadcrumb -->
            </div>
            <!-- //container -->
        </div>
    </div><!-- Page Banner Section End -->
    <!-- Post Section Start -->
    <div class="post-section section mt-50">
        <div class="container">
            <!-- Feature Post Row Start -->
            <div class="row">
                <div class="col-12">
                    <div class="error-404">
                        <h4 class="error-title"><?php esc_html_e('Ooops!... Error 404', 'newsmania') ?> </h4>

                        <p class="error-sub-title"><?php esc_html_e("Sorry, but the page you are looking for doesn't exist.", 'newsmania') ?> </p>

                        <div class="error-super-sub"><?php esc_html_e('You can go to the', 'newsmania') ?> <a
                                href="<?php echo esc_url(home_url()); ?>"><?php esc_html_e('HOMEPAGE', 'newsmania') ?></a>
                        </div>
                    </div>
                    <!-- Post Block Wrapper Start -->
                    <div class="post-block-wrapper">
                        <!-- Post Block Head Start -->
                        <div class="head">
                            <!-- Title -->
                            <h4 class="title">Our Latest Post</h4>
                        </div>
                        <!-- Post Block Head End -->
                        <div class="simple-line line-life-style"></div>
                        <!-- Post Block Body Start -->
                        <div class="body">
                            <div class="row mb-40">
                                <?php
                                $args = array(
                                    'posts_per_page' => 7
                                );
                                $featured = new WP_Query($args);
                                if ($featured->have_posts()) {
                                    while ($featured->have_posts()) {
                                        $featured->the_post();
                                        ?>
                                        <!-- Post Start -->
                                        <div <?php post_class('post overlay life-style-post col-md-3'); ?>>
                                            <div class="post-wrap">
                                                <!-- Category -->
                                                <?php
                                                $cats = get_the_category();
                                                foreach ($cats as $cat) {
                                                    echo '<a class="category life-style" href="' . esc_url(get_category_link($cat)) . '">' . $cat->cat_name . '</a> ';
                                                }
                                                ?>
                                                <!-- Image -->
                                                <a class="image" href="<?php the_permalink(); ?>">
                                                    <?php if (has_post_thumbnail()) { ?>
                                                        <img src="<?php echo get_the_post_thumbnail_url(); ?>"
                                                             alt="<?php the_title(); ?>">
                                                    <?php } else {
                                                        ?>
                                                        <img
                                                            src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                    <?php } ?></a>
                                                <!-- Content -->
                                                <div class="content mt-10">
                                                    <!-- Title -->
                                                    <h4 class="title light"><a href="<?php the_permalink(); ?>">
                                                            <?php the_title(); ?> </a></h4>
                                                    <!-- Meta -->
                                                    <div class="meta fix">
                                                        <div class="meta-item">
                                                            <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                               class="author"><?php the_author(); ?></a>
                                                        </div>
                                                        <div class="meta-item">
                                                            <i class="fa fa-clock-o"></i>
                                                            <span class="date"><?php the_time('j M, Y'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php
                                    }
                                    wp_reset_postdata();
                                } else {
                                    require(locate_template('template-part/none-content.php'));
                                } ?>
                            </div>
                        </div>
                    </div>
                    <!-- Post Block Wrapper End -->
                </div>
            </div>
            <!-- Feature Post Row End -->
        </div>
    </div><!-- Post Section End -->
<?php
get_footer();
?>