<?php
/**
 * Created by PhpStorm.
 * User: dell
 * Date: 5/30/2018
 * Time: 11:10 PM
 */
if (!class_exists('newsmania_about_us_widget')) {
    class newsmania_about_us_widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'newsmania_about_us_widget',
                esc_html__('Newsmania_about_us_widget', 'newsmania'),
                array('description' => esc_html__('Newsmania_about_us_widget',
                    'newsmania'))
            );
        }

        public function widget($args, $instance)
        {
            echo $args['before_widget'];
            if (!empty($instance['Image'])) {
                ?>
                <p class="footer-logo"><img src="<?php echo esc_url($instance['Image']) ?>"
                                            alt="<?php esc_html_e('image', 'newsmania'); ?>"></p>
            <?php } ?>
            <div class="content fix">
                <?php if (!empty($instance['Authorbio'])) { ?>
                    <p><?php esc_html_e($instance['Authorbio'], 'newsmania'); ?></p>
                <?php } ?>
                <ol class="footer-contact">
                    <?php if (!empty($instance['address'])) { ?>
                        <li><i class="fa fa-home"></i><?php esc_html_e($instance['address'], 'newsmania'); ?></li>
                    <?php } ?>
                    <?php if (!empty($instance['mailid'])) { ?>
                        <li><i class="fa fa-envelope-o"></i><?php esc_html_e($instance['mailid'], 'newsmania') ?></li>
                    <?php } ?>
                    <?php if (!empty($instance['no'])) { ?>
                        <li><i class="fa fa-headphones"></i><?php esc_html_e($instance['no'], 'newsmania') ?></li>
                    <?php } ?>
                </ol>
                <div class="footer-social">
                    <?php if (!empty($instance['fb'])) { ?>
                        <a href="<?php echo esc_url($instance['fb']); ?>" class="facebook"
                           title="<?php esc_html_e('Facebook', 'newsmania'); ?>"><i class="fa fa-facebook"></i></a>
                    <?php } ?>
                    <?php if (!empty($instance['tw'])) { ?>
                        <a href="<?php echo esc_url($instance['tw']); ?>" class="twitter"
                           title="<?php esc_html_e('Twitter', 'newsmania'); ?>"><i
                                    class="fa fa-twitter"></i></a>
                    <?php } ?>
                    <?php if (!empty($instance['gp'])) { ?>
                        <a href="<?php echo esc_url($instance['gp']); ?>" class="google-plus"
                           title="<?php esc_html_e('Google+', 'newsmania'); ?>"><i
                                    class="fa fa-google-plus"></i></a>
                    <?php } ?>
                    <?php if (!empty($instance['dr'])) { ?>
                        <a href="<?php echo esc_url($instance['dr']); ?>" class="dribbble"
                           title="<?php esc_html_e('dribbble', 'newsmania'); ?>"><i class="fa fa-dribbble"></i></a>
                    <?php } ?>

                    <?php if (!empty($instance['ig'])) { ?>
                        <a href="<?php echo esc_url($instance['ig']); ?>" class="dribbble"
                           title="<?php esc_html_e('Instagram', 'newsmania'); ?>"><i class="fa fa-instagram"></i></a>
                    <?php } ?>

                </div>
            </div>

            <?php
            echo $args['after_widget'];
        }

        public function form($instance)
        {
            $Image = !empty($instance['Image']) ? $instance['Image'] : '';
            $Authorbio = !empty($instance['Authorbio']) ? $instance['Authorbio'] : '';
            $address = !empty($instance['address']) ? $instance['address'] : '';
            $mailid = !empty($instance['mailid']) ? $instance['mailid'] : '';
            $no = !empty($instance['no']) ? $instance['no'] : '';
            $fb = !empty($instance['fb']) ? $instance['fb'] : '';
            $ig = !empty($instance['ig']) ? $instance['ig'] : '';
            $tw = !empty($instance['tw']) ? $instance['tw'] : '';
            $dr = !empty($instance['dr']) ? $instance['dr'] : '';
            $gp = !empty($instance['gp']) ? $instance['gp'] : '';
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('Image')); ?>">
                    <?php esc_html_e('Image:', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('Image')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('Image')); ?>" type="text"
                       value="<?php echo esc_attr($Image); ?>">
                <span
                        class="description"><?php _e('Upload a image from media uploader and paste the url here.', 'newsmania'); ?></span>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('Authorbio')); ?>">
                    <?php esc_html_e('Author bio :', 'newsmania'); ?>
                </label>
                <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('Authorbio')); ?>"
                          name="<?php echo esc_attr($this->get_field_name('Authorbio')); ?>"><?php echo esc_textarea($Authorbio); ?></textarea>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('address')); ?>">
                    <?php esc_html_e('Address :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('address')); ?>" type="text"
                       value="<?php echo esc_attr($address); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('mailid')); ?>">
                    <?php esc_html_e('Mail-Id :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('mailid')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('mailid')); ?>" type="text"
                       value="<?php echo esc_attr($mailid); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('no')); ?>">
                    <?php esc_html_e('Phone no. :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('no')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('no')); ?>" type="text"
                       value="<?php echo esc_attr($no); ?>">
            </p>

            <p>
                <label for="<?php echo esc_attr($this->get_field_id('fb')); ?>">
                    <?php esc_html_e('Facebook :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('fb')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('fb')); ?>" type="text"
                       value="<?php echo esc_attr($fb); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('tw')); ?>">
                    <?php esc_html_e('Twitter :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('tw')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('tw')); ?>" type="text"
                       value="<?php echo esc_attr($tw); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('gp')); ?>">
                    <?php esc_html_e('Google+ :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('gp')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('gp')); ?>" type="text"
                       value="<?php echo esc_attr($gp); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('dr')); ?>">
                    <?php esc_html_e('Dribbble :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('dr')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('dr')); ?>" type="text"
                       value="<?php echo esc_attr($dr); ?>">
            </p>

            <p>
                <label for="<?php echo esc_attr($this->get_field_id('ig')); ?>">
                    <?php esc_html_e('Instagram :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('ig')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('ig')); ?>" type="text"
                       value="<?php echo esc_attr($ig); ?>">
            </p>
            <?php
        }

        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['Image'] = (!empty($new_instance['Image'])) ? strip_tags($new_instance['Image']) : '';
            $instance['Authorbio'] = (!empty($new_instance['Authorbio'])) ? strip_tags($new_instance['Authorbio']) : '';
            $instance['address'] = (!empty($new_instance['address'])) ? strip_tags($new_instance['address']) : '';
            $instance['mailid'] = (!empty($new_instance['mailid'])) ? strip_tags($new_instance['mailid']) : '';
            $instance['no'] = (!empty($new_instance['no'])) ? strip_tags($new_instance['no']) : '';
            $instance['fb'] = (!empty($new_instance['fb'])) ? strip_tags($new_instance['fb']) : '';
            $instance['ig'] = (!empty($new_instance['ig'])) ? strip_tags($new_instance['ig']) : '';
            $instance['tw'] = (!empty($new_instance['tw'])) ? strip_tags($new_instance['tw']) : '';
            $instance['dr'] = (!empty($new_instance['dr'])) ? strip_tags($new_instance['dr']) : '';
            $instance['gp'] = (!empty($new_instance['gp'])) ? strip_tags($new_instance['gp']) : '';
            return $instance;
        }
    }

    if (!function_exists('newsmania_about_us_widget')) {
        add_action('widgets_init', 'newsmania_about_us_widget');
        function newsmania_about_us_widget()
        {
            register_widget("newsmania_about_us_widget");
        }
    }
}
?>