<?php

class  Elementor_ticker_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ticker';
    }

    public function get_title()
    {
        return __('News Ticker', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-carousel';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'hot news',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no. of posts', 'newsmania'),
                'default' => '3',
            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();?>

        <div class="hot-news">
            <div class="headline-wrapper clearfix">
                <?php echo '<span class="headline-title">' . $settings['title'] . '</span>'?>
                <div class="headline clearfix">
                    <?php
                    $args = array(
                        'posts_per_page' => $settings['number']
                    );
                    $featured = new WP_Query($args);
                    if ($featured->have_posts()) {
                        $i = 0; ?>

                        <dl class="ticker-1 clearfix">
                            <?php
                            while ($featured->have_posts()) {
                                $featured->the_post();
                                if ($i < $settings['number']) {
                                    ?>
                                    <dd class="clearfix">
                                        <?php
                                        $cats = get_the_category();
                                        echo '<a class="entry-categories pull-left" href="' . esc_url(get_category_link($cats[0])) . '">' . $cats[0]->cat_name . '</a> ';
                                        ?>
                                        <a class="pull-left"
                                           href="<?php the_permalink(); ?>"><?php the_title(); ?></a><span
                                            class="pull-left">/</span>
                                    </dd>
                                <?php
                                }
                                $i++;
                            } ?>

                        </dl>
                    <?php
                    }?>
                </div>
            </div>
        </div>
    <?php
    }
} ?>