<?php

class Elementor_popular_cat_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'popular_cat';
    }

    public function get_title()
    {
        return __('Popular Posts', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-posts-grid';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'popular post',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('no. of posts', 'newsmania'),
                'default' => '3',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $pop_id = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo  $pop_id; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?>
            }

            .simple-line.<?php echo  $pop_id; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post .post-wrap .category.<?php echo $pop_id; ?> {
                background-color: <?php echo $settings['linecolor'];?>
            }

            .post-block-carousel.<?php echo $pop_id; ?> .slick-arrow:hover {
                background: <?php echo $settings['linecolor'];?> !important;
                border-color: <?php echo $settings['linecolor'];?> !important;
            }
            .post.overlay .post-wrap .content .meta a.<?php echo $pop_id; ?>:hover {
                color: <?php echo $settings['linecolor'];?> !important;
            }
        </style>
        <!-- Popular Section Start -->
        <div class="popular-section section">
            <div class="container">
                <div class="row">
                    <div class="col">
                        <div class="post-block-wrapper">
                            <div class="head">
                                <?php echo '<h4 class="title">' . $settings['title'] . '</h4>' ?>
                            </div>
                            <!-- Post Block Head End -->
                            <div class="simple-line <?php echo $pop_id; ?>"></div>
                            <div class="popular-post-slider post-block-carousel <?php echo $pop_id; ?>">
                                <?php
                                $arr = array('posts_per_page' => $settings['number'],
                                    'orderby' => 'comment_count');
                                $posts = new WP_Query($arr);
                                if ($posts->have_posts()) {
                                    $i = 0;
                                    while ($posts->have_posts()) {
                                        $posts->the_post();
                                        if ($i < $settings['number']) {
                                            ?>
                                            <div class="post overlay popular-post">
                                                <div class="post-wrap">
                                                    <div class="image">
                                                        <?php if (has_post_thumbnail()) { ?>
                                                            <?php the_post_thumbnail('newsmania-elementor-popular-view'); ?>
                                                        <?php } else {
                                                            ?>
                                                            <img
                                                                src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                        <?php } ?>
                                                    </div>

                                                    <!-- Content -->
                                                    <div class="content text-overlay">
                                                        <?php
                                                        $cats = get_the_category();
                                                        echo '<a class="category travel ' . $pop_id . '"
                                                     href="' . esc_url(get_category_link($cats[0])) . '">' . $cats[0]->cat_name
                                                            . '</a> '; ?>
                                                        <!-- Title -->
                                                        <h4 class="title"><a
                                                                href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                        </h4>
                                                        <!-- Meta -->
                                                        <div class="meta fix">
                                                            <div class="meta-item">
                                                                <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                                   class="author <?php echo $pop_id; ?>"><?php the_author(); ?></a>
                                                            </div>
                                                            <div class="meta-item">
                                                                <i class="fa fa-clock-o"></i>
                                                                <span class="date"><?php the_time('j M, Y'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php
                                        }
                                        $i++;
                                    }
                                } ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Popular Section End -->
    <?php
    }
}

?>