<?php

class Elementor_cat_block_7_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return ' cat_video_7';
    }

    public function get_title()
    {
        return __('Categories Video Block', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-slider-video';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('no. of posts', 'newsmania'),
                'default' => '8',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $video = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo$video; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo $video; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .video-post-carousel.<?php echo $video; ?> .slick-arrow:hover {
                background: <?php echo $settings['linecolor'];?> !important;
                border-color: <?php echo $settings['linecolor'];?> !important;
            }
        </style>
        <!-- Post Block Head Start -->
        <div class="head">
            <!-- Title -->
            <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
        </div><!-- Post Block Head End -->
        <div class="simple-line line-video <?php echo $video;?>"></div>
        <!-- Post Block Body Start -->
        <div class="body">
            <?php
            $arr = array('posts_per_page' => $settings['number'],
                'tax_query' => array(
                    array(
                        'taxonomy' => 'post_format',
                        'field' => 'slug',
                        'terms' => array(
                            'post-format-video'
                        ))),
            );
            $posts = new WP_Query($arr);
            if ($posts->have_posts()) {
                $i = 0; ?>
                <!-- Sidebar Post Slider Start -->
                <div class="sidebar-post-carousel post-block-carousel video-post-carousel <?php echo $video; ?>">

                    <?php while ($posts->have_posts()) {
                        $posts->the_post();
                        if ($i < $settings['number']) { ?>
                            <div class="post video-post">
                                <div class="post-wrap">
                                    <?php if (get_post_format() == 'video') { ?>
                                        <a href="<?php echo esc_url(get_post_meta(get_the_ID(), '_format_video_embed', true)) ?>"
                                           class="image video-popup">
                                            <?php if (has_post_thumbnail()) { ?>
                                                <?php the_post_thumbnail('newsmania-elementor-home2-cat'); ?>
                                            <?php } else { ?>
                                                <img src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                            <?php } ?>
                                                                            <span class="video-btn"><i
                                                                                    class="fa fa-play-circle-o"></i></span>
                                        </a>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php
                        }
                        $i++;
                    } ?>
                </div><!-- Sidebar Post Slider End -->
            <?php }?>
        </div><!-- Post Block Body End -->
        <!-- Post Block Wrapper Start -->
    <?php
    }
}
