<?php

class Elementor_cat_block_6_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return ' cat_block_6';
    }

    public function get_title()
    {
        return __('Categories Block 6', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-slideshow';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('no. of posts', 'newsmania'),
                'default' => '8',
            )
        );
        $cats = get_categories();
        $arr = array();
        foreach ($cats as $cat) {
            $arr[$cat->cat_ID] = $cat->cat_name;
        }

        $this->add_control(
            'selectcate',
            array(
                'label' => __('select categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT,

                'options' => $arr

            ));
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $business = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo $business; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo $business; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post-block-carousel.business-post-carousel.<?php echo $business; ?> .slick-arrow:hover {

                background: <?php echo $settings['linecolor'];?> !important;
                border-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post .post-wrap .category.<?php echo $business; ?> {
                background: <?php echo $settings['linecolor'];?>
            }

            .post.overlay .post-wrap .content.text-overlay .title a.<?php echo $business; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }
        </style>

        <!-- Post Block Head Start -->
        <div class="head">
            <!-- Title -->
            <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
        </div><!-- Post Block Head End -->
        <div class="simple-line line-business <?php echo $business;?>"></div>
        <!-- Post Block Body Start -->
        <div class="body">
            <?php
            $arr = array('posts_per_page' => $settings['number'],
                'cat' => $settings['selectcate']
            );
            $posts = new WP_Query($arr);
            if ($posts->have_posts()) {
                $i = 0; ?>
                <!-- Sidebar Post Slider Start -->
                <div class="sidebar-post-carousel post-block-carousel business-post-carousel <?php echo $business; ?>">
                    <?php while ($posts->have_posts()) {
                        $posts->the_post();
                        if ($i < $settings['number']) { ?>
                            <div class="post overlay">
                                <div class="post-wrap">

                                    <!-- Image -->
                                    <div class="image">
                                        <?php if (has_post_thumbnail()) { ?>
                                            <?php the_post_thumbnail('newsmania-elementor-home2-cat'); ?>
                                        <?php } else { ?>
                                            <img src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                        <?php } ?>
                                    </div>

                                    <!-- Content -->
                                    <div class="content text-overlay">

                                        <?php if ($i == 0) {
                                            $cats = get_the_category();
                                            echo '<a class="category business ' . $business . '"
                                                     href="' . esc_url(get_category_link($cats[0])) . '">' .
                                                $cats[0]->cat_name
                                                . '</a> ';
                                        } ?>
                                        <!-- Title -->
                                        <h4 class="title"><a class="<?php echo $business; ?>sz"
                                                             href="<?php the_permalink(); ?>">
                                                <?php the_title(); ?></a></h4>
                                        <!-- Meta -->
                                        <div class="meta fix">
                                    <span class="meta-item date"><i
                                            class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        <?php
                        }
                        $i++;
                    } ?>

                </div><!-- Sidebar Post Slider End -->
            <?php }?>
        </div><!-- Post Block Body End -->
        <!-- Post Block Wrapper Start -->
    <?php
    }
}
