<?php

class Elementor_cat_block_16_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'cat_block_16';
    }

    public function get_title()
    {
        return __('Categories Block 16', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-posts-group';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter title name', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no of post', 'newsmania'),
                'default' => '9',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );
        $cats = get_categories();
        $arr = array();
        foreach ($cats as $cat) {
            $arr[$cat->cat_ID] = $cat->cat_name;
        }
        $this->add_control(
            'selectcate',
            array(
                'label' => __('select categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT,

                'options' => $arr
            ));
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $trend_id = 'id-' . uniqid(); ?>
        <style>
            .simple-line.<?php echo$trend_id; ?> {
                border-bottom-color: <?php echo $settings['linecolor']?> !important;
            }

            .simple-line.<?php echo $trend_id; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post.video-post .content .title a.<?php echo $trend_id; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post.video-post .content .meta a.<?php echo $trend_id; ?>:hover {
                color:

            <?php echo $settings['linecolor'];?>
        </style>

        <!-- Post Block Head Start -->
        <!-- Football Post Row Start -->
        <div class="row ">
            <div class="col-12">
                <!-- Post Block Wrapper Start -->
                <div class="post-block-wrapper">
                    <!-- Post Block Head Start -->
                    <div class="head">
                        <!-- Title -->
                        <?php echo '<h4 class="title">' . $settings['title'] . '</h4>' ?>

                    </div>
                    <!-- Post Block Head End -->
                    <div class="simple-line line-video <?php echo $trend_id; ?> "></div>
                    <!-- Post Block Body Start -->
                    <div class="body pb-0">
                        <div class="row">
                            <?php
                            $post_ids = array();
                            $arr = array('posts_per_page' => $settings['number'],
                                'cat' => $settings['selectcate'],
                            );
                            $posts = new WP_Query($arr);
                            if ($posts->have_posts()) {
                                $i = 0;
                                while ($posts->have_posts()) {
                                    $posts->the_post();
                                    $post_ids[] = get_the_ID(); ?>
                                    <div <?php post_class('post video-post col-lg-8 col-12') ?>>
                                        <div class="post-wrap mb-15">
                                            <a href="<?php echo esc_url(get_post_meta(get_the_ID(), '_format_video_embed', true)) ?>"
                                               class="image video-popup">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('newsmania-elementor-block-16-1');
                                                } else { ?>
                                                    <img
                                                            src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                <?php } ?>
                                                <?php if (get_post_format() == 'video') { ?>
                                                    <span class="video-btn"><i
                                                                class="fa fa-play-circle-o"></i></span>
                                                <?php } ?>
                                            </a>

                                            <div class="content">
                                                <h4 class="title"><a class="<?php echo $trend_id; ?>"
                                                                     href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                </h4>

                                                <div class="meta fix">
                                                    <div class="meta-item">
                                                        <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                        <a class="<?php echo $trend_id; ?>"
                                                           href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                           class="author"><?php the_author(); ?></a>
                                                    </div>
                                                    <div class="meta-item">
                                                        <i class="fa fa-clock-o"></i>
                                                        <span class="date"><?php the_time('j M, Y'); ?></span>
                                                    </div>
                                                </div>

                                            </div>

                                        </div>
                                    </div>
                                    <?php
                                    if ($i == 0) {
                                        break;

                                    }
                                    $i++;
                                }
                                wp_reset_postdata();
                            } ?>
                            <div class="col-lg-4 col-12">
                                <div class="row">
                                    <?php
                                    $arr = array('posts_per_page' => $settings['number'],
                                        'cat' => $settings['selectcate'],
                                        'post__not_in' => $post_ids
                                    );
                                    $posts = new WP_Query($arr);
                                    if ($posts->have_posts()) {
                                        $j = 0;
                                        while ($posts->have_posts()) {
                                            $posts->the_post();
                                            if ($j < $settings['number']) { ?>
                                                <div
                                                        class="post video-post post-small post-list post-separator-border col-lg-12 col-md-6 col-12">
                                                    <div class="post-wrap">

                                                        <!-- Image -->
                                                        <a href="<?php echo esc_url(get_post_meta(get_the_ID(), '_format_video_embed', true)) ?>"
                                                           class="image video-popup">
                                                            <?php if (has_post_thumbnail()) {
                                                                the_post_thumbnail('newsmania-elementor-block-16-2');
                                                            } else { ?>
                                                                <img
                                                                        src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                            <?php } ?>
                                                            <?php if (get_post_format() == 'video') { ?>
                                                                <span class="video-btn small"><i
                                                                            class="fa fa-play-circle-o"></i></span>
                                                            <?php } ?>
                                                        </a>

                                                        <!-- Content -->
                                                        <div class="content">

                                                            <!-- Title -->
                                                            <h4 class="title"><a class="<?php echo $trend_id; ?>"
                                                                                 href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                            </h4>
                                                            <!-- Meta -->
                                                            <div class="meta fix">
                                    <span class="meta-item date"><i
                                                class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                            </div>

                                                        </div>

                                                    </div>
                                                </div>
                                                <?php
                                            }
                                            $j++;
                                        }
                                    } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Post Block Body End -->
                </div>
                <!-- Post Block Wrapper End -->
            </div>
        </div><!-- Football Post Row End -->
        <!-- Post Block Wrapper Start -->
        <?php
    }
}
