<?php

class Elementor_cat_block_15_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'cat_block_15';
    }

    public function get_title()
    {
        return __('Categories', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );

        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $id = 'id-' . uniqid(); ?>
        <style>
            .simple-line.<?php echo  $id ; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo $id ; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .sidebar-category.fashion-category li a.<?php echo $id ; ?>:hover {
                color: <?php echo $settings['linecolor'];?> !important
            }
        </style>
        <div class="clearfix">
            <!-- Sidebar Block Wrapper -->
            <div class="sidebar-block-wrapper">
                <!-- Sidebar Block Head Start -->
                <div class="head">
                    <!-- Title -->
                    <?php echo '<h4 class="title">' . $settings['title'] . '</h4>' ?>
                </div>
                <!-- Sidebar Block Head End -->
                <div class="simple-line line-fashion <?php echo $id; ?>"></div>
                <!-- Sidebar Block Body Start -->
                <div class="body">
                    <ul class="sidebar-category fashion-category">
                        <?php
                        $cats = get_categories();
                        foreach ($cats as $cat) {
                            ?>
                            <li><a class="<?php echo $id; ?> "
                                   href="<?php echo esc_url(get_category_link($cat)) ?>"><?php echo $cat->cat_name; ?>
                                    <span class="badge bg-sports pull-right"><?php echo $cat->count; ?></span>
                                </a></li>
                        <?php } ?>
                    </ul>
                </div>
                <!-- Sidebar Block Body End -->
            </div>
        </div>
        <?php
    }
}

?>