<?php

class Elementor_cat_block_10_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'cat_block_10';
    }

    public function get_title()
    {
        return __('Categories Block Tab', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-tabs';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no. of posts', 'newsmania'),
                'default' => '5',
            )
        );
        $this->add_control(
            'title1',
            array(
                'label' => __('Title 1', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'lastest news',
            )
        );
        $this->add_control(
            'title2',
            array(
                'label' => __('Title 2', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'popular news',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $newsid = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo  $newsid; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo  $newsid; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .sidebar-tab-list.sports-sidebar-tab-list a.active.<?php echo  $newsid; ?> {
                background-color: <?php echo $settings['linecolor'];?>
            }

            a.<?php echo $newsid; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post.education-post .content .title a:hover {
                color: <?php echo $settings['linecolor'];?>
            }
        </style>

        <!-- Single Sidebar -->
        <div class="clearfix">

            <!-- Sidebar Block Wrapper -->
            <div class="sidebar-block-wrapper">

                <!-- Sidebar Block Head Start -->
                <div class="head">
                    <!-- Tab List -->
                    <div class="sidebar-tab-list sports-sidebar-tab-list nav">
                        <a class="active <?php echo $newsid; ?>" data-toggle="tab"
                           href="#tab1"><?php echo $settings['title1'] ?></a>
                        <a class=" <?php echo $newsid; ?>" data-toggle="tab"
                           href="#tab2"><?php echo $settings['title2'] ?></a>
                    </div>
                </div>
                <!-- Sidebar Block Head End -->
                <div class="simple-line border-t-0 line-sports <?php echo $newsid; ?>"></div>
                <!-- Sidebar Block Body Start -->
                <div class="body">
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="tab1">
                            <!-- Small Post Start -->
                            <?php
                            $arr = array('posts_per_page' => $settings['number'],

                            );
                            $posts = new WP_Query($arr);
                            if ($posts->have_posts()) {
                                $j = 0;
                                while ($posts->have_posts()) {
                                    $posts->the_post();
                                    if ($j < $settings['number']) { ?>

                                        <div class="post post-small post-list education-post post-separator-border">
                                            <div class="post-wrap">

                                                <!-- Image -->
                                                <a class="image"
                                                   href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>
                                                        <?php the_post_thumbnail('newsmania-elementor-travel1'); ?>
                                                    <?php } else {
                                                        ?>
                                                        <img
                                                            src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                    <?php } ?></a>
                                                <!-- Content -->
                                                <div class="conttent">

                                                    <!-- Title -->
                                                    <h5 class="title"><a class="<?php echo $newsid; ?>"
                                                                         href="<?php the_permalink(); ?>">
                                                            <?php the_title(); ?></a></h5>
                                                    <!-- Meta -->
                                                    <div class="meta fix">
                                            <span class="meta-item date"><i
                                                    class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                    </div>

                                                </div>
                                            </div>
                                        </div><!-- Small Post End -->
                                    <?php
                                    }
                                    $j++;
                                }
                                wp_reset_postdata();
                            } ?>
                        </div>
                        <div class="tab-pane fade" id="tab2">
                            <?php
                            $arr = array('posts_per_page' => $settings['number'],
                                'orderby' => 'comment_count'
                            );
                            $posts = new WP_Query($arr);

                            if ($posts->have_posts()) {
                                $i = 0;
                                while ($posts->have_posts()) {
                                    $posts->the_post();
                                    if ($i < $settings['number']) { ?>
                                        <div class="post post-small post-list education-post post-separator-border">
                                            <div class="post-wrap">
                                                <!-- Image -->
                                                <a class="image"
                                                   href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>
                                                        <?php the_post_thumbnail('newsmania-elementor-travel1'); ?>
                                                    <?php } else {
                                                        ?>
                                                        <img
                                                            src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                    <?php } ?></a>
                                                <!-- Content -->
                                                <div class="content">
                                                    <!-- Title -->
                                                    <h5 class="title"><a class="<?php echo $newsid; ?>
                                                                href="<?php the_permalink(); ?>">
                                                        <?php the_title(); ?></a></h5>

                                                    <!-- Meta -->
                                                    <div class="meta fix">
                                           <span class="meta-item date"><i
                                                   class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                    </div>

                                                </div>
                                            </div>
                                        </div><!-- Small Post End -->
                                    <?php
                                    }
                                    $i++;
                                }
                                wp_reset_postdata();
                            } ?>
                        </div>
                    </div>
                </div>
                <!-- Sidebar Block Body End -->
            </div>
        </div>
    <?php
    }
}

