<?php

class Elementor_banner_2_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'banner_2';
    }

    public function get_title()
    {
        return __('Banner 2', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-insert-image';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'image',
            array(
                'label' => __('Choose Image', 'newsmania'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => array(
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ),
            )
        );
        $this->add_control(
            'link',
            array(
                'label' => __('Link', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter link', 'newsmania'),
                'default' => 'link',
            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();?>
        <div>
            <a href="<?php echo $settings['link']?> "
               class="post-middle-banner"><?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html($settings)?></a>
        </div>
    <?php
    }
}

?>