<?php
newsmania_setPostViews(get_the_ID());
get_header();
?>
    <!-- Page Banner Section Start -->
<?php
$arr = get_option('Newsmania');
$bread = isset($arr['opt-page_Breadcrumb_header']) ? $arr['opt-page_Breadcrumb_header'] : '1';
if ($bread == 1) { ?>
    <div class="page-banner section">
    <?php
    $arr = get_option('Newsmania');
    $image = $arr['opt-page-background'];
    if (isset($image['url']) && $image['url'] != '') { ?>
        <div class="page-title-wrapper" style="background-image: url(<?php echo $image['url'] ?>);">
    <?php } else {
        ?>
        <div class="page-title-wrapper">
    <?php } ?>
    <div class="container clearfix">
        <h2 class="pull-left title"><?php echo get_the_title(); ?></h2>
        <!-- breadcrumb -->
        <ol class="breadcrumb pull-right">
            <li class="breadcrumb-item"><a
                    href="<?php echo esc_url(home_url('/')); ?>"><?php esc_html_e('Home', 'newsmania'); ?></a>
            </li>
            <li class="breadcrumb-item active"><?php echo get_the_title(); ?></li>
        </ol>
        <!-- //breadcrumb -->
    </div>
    <!-- //container -->
    </div>
    </div>
<?php } ?><!-- Page Banner Section End -->
    <!-- Blog Section Start -->
    <div class="blog-section section mt-50">
        <div class="container">
            <!-- Feature Post Row Start -->
            <div class="row">
                <?php $side = isset($arr['opt-page_sidebar_setting']) ? $arr['opt-page_sidebar_setting'] : 'right';
                if ('left' == $side) { ?>
                    <div class="col-lg-4 col-12 mb-50">
                        <div class="row">
                            <?php get_sidebar(); ?>
                        </div>
                    </div>
                <?php } ?>
                <div class="<?php echo 'hide' == $side ? 'col-lg-12' : 'col-lg-8'; ?> col-lg-8 col-12 mb-50">
                    <?php
                    if (have_posts()) {
                        while (have_posts()) {
                            the_post(); ?>
                            <!-- Single Blog Start -->
                            <div class="single-blog mb-50">
                                <div class="blog-wrap">
                                    <!-- Image -->
                                    <?php if (has_post_thumbnail()) { ?>
                                        <div class="image"><img src="<?php echo get_the_post_thumbnail_url(); ?>"
                                                                alt="<?php the_title(); ?>"></div>
                                    <?php } ?>
                                    <!-- Title -->
                                    <h3 class="title"><?php the_title(); ?></h3>
                                    <!-- Meta -->
                                    <div class="meta fix">
                                        <div class="meta-item">
                                            <span><?php esc_html_e('by', 'newsmania') ?></span>
                                            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                               class="author"><?php the_author(); ?></a>
                                        </div>
                                        <div class="meta-item">
                                            <i class="fa fa-clock-o"></i>
                                            <span class="date"><?php the_time('j M, Y'); ?></span>
                                        </div>
                                        <div class="meta-item">
                                            <a href="<?php comments_link(); ?>" class="comments"><i
                                                    class="fa fa-comments"></i><?php echo get_comments_number(); ?></a>
                                        </div>
                                        <div class="meta-item">
                                            <span class="view"><i
                                                    class="fa fa-eye"></i><?php echo newsmania_getPostViews(get_the_ID()); ?></span>
                                        </div>
                                    </div>
                                    <!-- Content -->
                                    <div class="content">
                                        <!-- Description -->
                                        <?php the_content(); ?>
                                    </div>
                                    <div class="tags-social float-left">
                                        <?php if (has_tag()) { ?>
                                            <div class="tags float-left">
                                                <i class="fa fa-tags"></i>
                                                <?php
                                                $tags = get_the_tags();
                                                foreach ($tags as $tag) {
                                                    echo "<a href='" . esc_url(get_tag_link($tag)) . "'>$tag->name</a>";
                                                } ?>
                                            </div>
                                        <?php } ?>
                                        <?php $share = isset($arr['opt-hide_page_post_share']) ? $arr['opt-hide_page_post_share'] : '0';
                                        if ($share == 0) { ?>
                                            <div class="blog-social float-right">
                                                <?php if (function_exists('newsmania_social_share')) {
                                                    newsmania_social_share();
                                                } ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div><!-- Single Blog End -->
                            <div class="post-nav mb-50">
                                <?php $prev = get_previous_post();
                                if ($prev) { ?>
                                    <a href="<?php the_permalink($prev) ?>"
                                       class="prev-post"><span>previous post</span><?php echo get_the_title($prev); ?>
                                    </a>
                                <?php } ?>
                                <?php $next = get_next_post();

                                if ($next) { ?>
                                    <a href="<?php the_permalink($next) ?>"
                                       class="next-post"><span>next post</span><?php echo get_the_title($next); ?></a>
                                <?php } ?>
                            </div><!-- Previous & Next Post End -->
                            <!-- Post Author Start -->
                            <?php $authorbox = isset($arr['opt-hide_page_author_box']) ? $arr['opt-hide_page_author_box'] : '0';
                            if ($authorbox == 0) { ?>
                                <div class="post-author fix mb-50">

                                    <div class="image float-left"><img
                                            src="<?php echo esc_url(get_avatar_url(get_the_author_meta('ID'))); ?>"
                                            alt="<?php the_author(); ?>"></div>
                                    <div class="content fix">
                                        <h5>
                                            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
                                        </h5>

                                        <p><?php echo get_the_author_meta('description'); ?></p>

                                        <div class="social">
                                            <?php $f = get_the_author_meta('facebook');
                                            if (!empty($f)) { ?>
                                                <a href="<?php echo esc_url($f); ?>"><i
                                                        class="fa fa-facebook"></i></a>
                                            <?php }
                                            $t = get_the_author_meta('twitter');
                                            if (!empty($t)) { ?>
                                                <a href="<?php echo esc_url($t); ?>"><i
                                                        class="fa fa-twitter"></i></a>
                                            <?php }
                                            $g = get_the_author_meta('google-plus');
                                            if (!empty($g)) { ?>
                                                <a href="<?php echo esc_url($g); ?>"><i
                                                        class="fa fa-google-plus"></i></a>
                                            <?php }
                                            $d = get_the_author_meta('dribbble');
                                            if (!empty($d)) { ?>
                                                <a href="<?php echo esc_url($d); ?>"><i
                                                        class="fa fa-dribbble"></i></a>
                                            <?php }
                                            $p = get_the_author_meta('pinterest');
                                            if (!empty($p)) {
                                                ?>
                                                <a href="<?php echo esc_url($p); ?>"><i
                                                        class="fa fa-pinterest"></i></a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?><!-- Post Author End -->
                            <!-- Post Block Wrapper Start -->
                            <?php $related = isset($arr['opt-hide_page_related posts box']) ? $arr['opt-hide_page_related posts box'] : '0';
                            if ($related == 0) {
                                $otherAuthorPosts = new WP_Query(array(
                                    'author' => get_the_author_meta('ID'),
                                    'posts_per_page' => 2,
                                    'post__not_in' => array(get_the_ID())
                                ));
                                if ($otherAuthorPosts->have_posts()) { ?>
                                    <div class="post-block-wrapper mb-50">
                                        <!-- Post Block Head Start -->
                                        <div class="head">
                                            <!-- Title -->
                                            <h4 class="title"><?php esc_html_e('You might also like', 'newsmania'); ?></h4>
                                        </div>
                                        <!-- Post Block Head End -->
                                        <div class="simple-line line-sports"></div>
                                        <!-- Post Block Body Start -->
                                        <div class="body">
                                            <div
                                                class="two-column-post-carousel column-post-carousel post-block-carousel sports-post-carousel row">
                                                <?php
                                                while ($otherAuthorPosts->have_posts()) {
                                                    $otherAuthorPosts->the_post(); ?>
                                                    <div class="col-md-6 col-12">
                                                        <!-- Overlay Post Start -->
                                                        <div <?php post_class('post overlay hero-post'); ?>>
                                                            <div class="post-wrap">
                                                                <!-- Image -->
                                                                <div class="image">
                                                                    <?php if (has_post_thumbnail()) { ?>
                                                                        <?php the_post_thumbnail('newsmania-thumbnail-image'); ?>
                                                                    <?php } else {
                                                                        ?>
                                                                        <img
                                                                            src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                                    <?php } ?>
                                                                </div>
                                                                <!-- Category -->
                                                                <?php
                                                                $cats = get_the_category();
                                                                echo '<a class="category" href="' . esc_url(get_category_link($cats[0])) . '">' . $cats[0]->cat_name . '</a> ';
                                                                ?>
                                                                <!-- Content -->
                                                                <div class="content text-overlay">
                                                                    <!-- Title -->
                                                                    <h4 class="title"><a
                                                                            href="<?php the_permalink(); ?>"><?php the_title(); ?>
                                                                        </a></h4>
                                                                    <!-- Meta -->
                                                                    <div class="meta fix">
                                                    <span class="meta-item date"><i
                                                            class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- Overlay Post End -->
                                                    </div>
                                                <?php
                                                }
                                                wp_reset_postdata();
                                                ?>
                                            </div>
                                        </div>
                                        <!-- Post Block Body End -->
                                    </div><!-- Post Block Wrapper End -->
                                <?php }
                            }
                        }
                        wp_reset_postdata();
                    } else {
                        require(locate_template('template-part/none-content.php'));
                    }
                    $comment = isset($arr['opt-hide_page_comment_box']) ? $arr['opt-hide_page_comment_box'] : '0';
                    if ($comment == 0) {
                        comments_template();
                    } ?>
                </div>
                <?php if ('right' == $side) { ?>
                    <div class="col-lg-4 col-12 mb-50">
                        <div class="row">
                            <?php get_sidebar(); ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div><!-- Feature Post Row End -->
<?php
get_footer();
?>