<?php
/**
 * Get Post Views
 */
if (!function_exists('newsmania_getPostViews')) {
    function newsmania_getPostViews($postID)
    {
        $count_key = 'newsmania_post_views_count';
        $count = get_post_meta($postID, $count_key, true);
        if (empty($count)) {

            update_post_meta($postID, $count_key, '0');

            return "0";
        }

        return newsmania_get_formatted_postView($count);
    }
}

/**
 * Set Post Views
 */
if (!function_exists('newsmania_setPostViews')) {
    function newsmania_setPostViews($postID)
    {
        $count_key = 'newsmania_post_views_count';
        $count = get_post_meta($postID, $count_key, true);
        if (empty($count)) {
            $count = 1;

            update_post_meta($postID, $count_key, '1');
        } else {
            $count++;
            update_post_meta($postID, $count_key, $count);
        }
    }
}

/**
 * Utility function to format the button count,
 * appending "K" if one thousand or greater,
 * "M" if one million or greater,
 * and "B" if one billion or greater (unlikely).
 * $precision = how many decimal points to display (1.25K)
 */
if (!function_exists('newsmania_get_formatted_postView')) {
    function newsmania_get_formatted_postView($number)
    {
        $precision = 2;
        if ($number >= 1000 && $number < 1000000) {
            $formatted = number_format($number / 1000, $precision) . 'K';
        } else if ($number >= 1000000 && $number < 1000000000) {
            $formatted = number_format($number / 1000000, $precision) . 'M';
        } else if ($number >= 1000000000) {
            $formatted = number_format($number / 1000000000, $precision) . 'B';
        } else {
            $formatted = $number; // Number is less than 1000
        }
        $formatted = str_replace('.00', '', $formatted);

        return $formatted;
    }
}

// Remove issues with prefetching adding extra views
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);