<?php
if (!function_exists('newsmania_comments')) {
    function newsmania_comments($comment, $args, $depth)
    {
        global $post;
        $GLOBALS['comment'] = $comment;
        switch ($comment->comment_type) :
            case 'pingback' :
            case 'trackback' :
// Display trackbacks differently than normal comments.
                ?>

                <div class="comment-content pingback">
                    <div class="head">
                        <?php esc_html_e('Pingback', 'newsmania'); ?>
                    </div>
                    <div class="content fix">
                        <?php comment_author_link(); ?>
                    </div>
                </div>

                <?php
                break;
            default :
                ?>

            <div  class="<?php echo $comment->comment_parent ? 'children' : '' ?>">
                <div id="comment-<?php comment_ID(); ?>" <?php comment_class("post-comment fix"); ?>>
                    <div class="image float-left">
                        <?php echo get_avatar($comment); ?>
                    </div>
                    <div class="content fix">
                        <h5><?php comment_author_link(); ?></h5>

                        <p><?php comment_text(); ?></p>
                        <?php comment_reply_link(array_merge($args, array(
                                'reply_text' => '<i class="fa fa-mail-forward"></i> ' . esc_html__('Reply', 'newsmania'),
                                'depth' => $depth,
                                'max_depth' => $args['max_depth'],
                                'before' => '<span class="reply-arrow">',
                                'after' => '</span>',
                            )

                        )); ?>

                        <!-- .reply -->
                    </div>
                </div>
                <!-- .comment-details -->
                <?php
                break;
        endswitch; // End comment_type check.
    }
}


if (!function_exists('newsmania_move_comment_field')) {
    function newsmania_move_comment_field($fields)
    {
        $comment_field = $fields['comment'];
        unset($fields['comment']);
        $fields['comment'] = $comment_field;
        return $fields;
    }

    add_filter('comment_form_fields', 'newsmania_move_comment_field');
}

/**
 * Add custom HTML between the `</h3>` and the `<form>` tags in the comment_form() output.
 */
if (!function_exists('newsmania_form_before')) {
    add_action('comment_form_before', function () {
        add_filter('pre_option_comment_registration', 'newsmania_form_before');
    });

    function newsmania_form_before($comment_registration)
    {
        // Adjust this to your needs:
        echo '<div class="body">
        <div class="post-comment-form">';

        remove_filter(current_filter(), __FUNCTION__);
        return $comment_registration;
    }
}