<?php
if (post_password_required()) {
    return;
}
if (have_comments()) {
    ?>
    <div class="post-block-wrapper">
        <div class="head">
            <div class="head-tag">
                <i class="fa fa-comments"></i>
            </div>
            <h4 class="title">Comments</h4>
        </div>
        <div class="body">
            <div class="post-comment-section">
                <?php
                wp_list_comments(array(
                    'style' => 'div',
                    'callback' => 'newsmania_comments',
                    'avatar_size' => '',
                    'depth' => 2
                ));
                ?>
            </div>
        </div>
    </div>
    <div class="post-nav mb-50">
        <?php previous_comments_link(__('previous comment', 'newsmania')); ?>

        <?php next_comments_link(__('next comment', 'newsmania')); ?>

    </div><!-- Previous & Next Post End -->
    <?php
}
if (comments_open()) {
    ?>
    <div class="post-block-wrapper">
        <?php
        $commenter = wp_get_current_commenter();
        $args = array(
            'title_reply_before' => '<div class="head"><div class="head-tag"><i class="fa fa-commenting"></i></div>
<h4 class="title">',
            'title_reply_after' => '</h4></div>',
            'label_submit' => esc_html__('Submit Comment', 'newsmania'),
            'class_form' => 'comment-form row',
            'submit_field' => '<div class="col-12">%1$s %2$s</div>',
            'fields' => apply_filters('comment_form_default_fields', array(
                    'author' =>
                        '<div class="col-md-6 col-12 mb-20">' .
                        '<label for="author">' . esc_html__('Name', 'newsmania') . ' <span class="required"><sup>*</sup></span></label>' .
                        '<input type="text" name="author" id="author" value="' . esc_attr($commenter['comment_author']) . '" required>' .
                        '</div>',

                    'email' =>
                        '<div class="col-md-6 col-12 mb-20">' .
                        '<label for="email">' . esc_html__('E-Mail', 'newsmania') . ' <span class="required"><sup>*</sup></span></label>' .
                        '<input type="email" name="email" id="email" value="' . esc_attr($commenter['comment_author_email']) . '" required>' .
                        '</div>',

                    'url' =>
                        '<div class="col-12 mb-20">' .
                        '<label for="url">' . esc_html__('Website', 'newsmania') . '</label>' .
                        '<input id="website" name="url" type="text" value="' . esc_url($commenter['comment_author_url']) . '" >' .
                        '</div>',
                )
            ),
            'comment_field' =>
                '<div class="col-12 mb-20">' .
                '<label for="message">' . esc_html__('Message', 'newsmania') . '<sup>*</sup></label>' .
                '<textarea name="comment" id="message" required></textarea>' .
                '</div>'
        );

        // To add custom class in comment form in comment.php in wp native themes
        ob_start();
        ?>
        <?php
        comment_form($args);
        ?>
    </div>
    </div>
    </div>
<?php }