<?php
/*
Plugin Name: newsmania Social share
Description: For social share
Author: Codentheme
Version: 1.0
*/

register_activation_hook(__FILE__,'newsmania_plugin_install');

function newsmania_plugin_install(){
    $arr = array();
    $arr['newsmania-fb']='on';
    $arr['newsmania-tw'] ='on';
    $arr['newsmania-li']='on';
    $arr['newsmania-pn']='on';
    $arr['newsmania-gp'] ='on';
    update_option('newsmaia_key', $arr);
}

add_action('admin_menu','newsmania_add_menu');

function newsmania_add_menu()
{
    add_theme_page('social','Newsmania Social Icon','manage_options','social','func_newsmania_social_icon');

}

/**
 * Social share icons
 */
if (!function_exists('newsmania_social_share')) {
    function newsmania_social_share()
    {
        $arr1 = get_option('newsmaia_key');
        if (isset($arr1['newsmania-fb']) && $arr1['newsmania-fb'] == 'on') { ?>
            <a href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>" class="social-icon m-auto si-facebook" onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=220,width=600');return false;"><i class="fa fa-facebook"></i><i class="fa fa-facebook"></i></a>
        <?php
        }
        if (isset($arr1['newsmania-tw']) && $arr1['newsmania-tw'] == 'on') { ?>
            <a href="https://twitter.com/share?url=<?php the_permalink(); ?>" class="social-icon m-auto si-twitter" onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=260,width=600');return false;"><i class="fa fa-twitter"></i><i class="fa fa-twitter"></i></a>
        <?php }
        if (isset($arr1['newsmania-li']) && $arr1['newsmania-li'] == 'on') { ?>
            <a  class="social-icon m-auto si-linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?> &title=<?php echo esc_html__('linkedin', 'nakhra'); ?>&summary=<?php echo urlencode(get_the_title()); ?>&source=<?php echo urlencode(get_the_title()); ?>"  onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="fa fa-linkedin"></i><i class="fa fa-linkedin"></i></a>

        <?php }
        if (isset($arr1['newsmania-pn']) && $arr1['newsmania-pn'] == 'on') { ?>
            <span></span>
            <a class="social-icon m-auto si-pinterest-p" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php if (function_exists('the_post_thumbnail')) echo esc_url(wp_get_attachment_url(get_post_thumbnail_id())); ?>&description=<?php echo urlencode(get_the_title()); ?>" onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="fa fa-pinterest-p"></i><i class="fa fa-pinterest-p"></i></a>
        <?php }

        if (isset($arr1['newsmania-gp']) && $arr1['newsmania-gp'] == 'on') { ?>
            <span></span>
            <a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" class="social-icon m-auto si-google"  onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="fa fa-google-plus"></i><i class="fa fa-google-plus"></i></a>
        <?php }

    }
}




function func_newsmania_social_icon()
{
    if (isset($_POST['submit'])) {
        $arr = array();
        if (isset($_POST['newsmania-fb'])) {
            $arr['newsmania-fb'] = $_POST['newsmania-fb'];
        }
        if (isset($_POST['newsmania-tw'])) {
            $arr['newsmania-tw'] = $_POST['newsmania-tw'];
        }
        if (isset($_POST['newsmania-li'])) {
            $arr['newsmania-li'] = $_POST['newsmania-li'];
        }
        if (isset($_POST['newsmania-pn'])) {
            $arr['newsmania-pn'] = $_POST['newsmania-pn'];
        }

        if (isset($_POST['newsmania-gp'])) {
            $arr['newsmania-gp'] = $_POST['newsmania-gp'];
        }
        update_option('newsmaia_key', $arr);
    }


    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Social Sharing Options', 'newsmania')?></h1>
        <form method="post" action="#">
            <table class="form-table">
                <?php $arr1 = get_option('newsmaia_key'); ?>

                <tr>
                    <th scope="row">
                        <label for="name">Facebook</label>
                    </th>
                    <td><input type="checkbox"  id="name" name="newsmania-fb" <?php  if (isset($arr1['newsmania-fb'])) { checked($arr1['newsmania-fb'],'on'); } ?>></td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="tw">Twitter</label>
                    </th>
                    <td><input type="checkbox" id="tw" name="newsmania-tw" <?php if (isset($arr1['newsmania-tw'])) {checked($arr1['newsmania-tw'],'on');}?>></td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="ln">Linkedin</label>
                    </th>
                    <td><input type="checkbox" id="ln" name="newsmania-li" <?php  if (isset($arr1['newsmania-li'])) { checked($arr1['newsmania-li'],'on');} ?>></td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="pn">Pinterest-n</label>
                    </th>
                    <td><input type="checkbox" id="pn" name="newsmania-pn" <?php if (isset($arr1['newsmania-pn'])) { checked($arr1['newsmania-pn'],'on');} ?>></td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gp">Google-plus</label>
                    </th>
                    <td><input type="checkbox" id="gp" name="newsmania-gp" <?php if (isset($arr1['newsmania-gp'])) { checked($arr1['newsmania-gp'],'on');} ?>></td>
                </tr>
            </table>

            <p class="submit">
                <input type="submit" name="submit" value="submit" class="button button-primary">
            </p>


        </form>
    </div>

<?php }?>
