<?php

if (!class_exists('newsmania_recentpost_widget')) {
    class newsmania_recentpost_widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'newsmania_recentpost_widget',
                esc_html__('Newsmania Recent Post Widget', 'newsmania'),
                array('description' => esc_html__('Newsmania Recent Post Widget.',
                    'newsmania'))
            );
        }

        /**
         * Front-end display of widget.
         */
        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', esc_html($instance['title']), $instance, $this->id_base) . $args['after_title'];
            }
            ?>
            <?php
            $arr = array('posts_per_page' => $instance['noOfPost']);
            $posts = new WP_Query($arr);
            if ($posts->have_posts()) {
                $i = 0;
                while ($posts->have_posts()) {
                    $posts->the_post();
                    if ($i < $instance['noOfPost']) {
                        ?>

                        <div class="footer-widget-post">
                            <div class="post-wrap">

                                <a href="<?php the_permalink(); ?>" class="image">
                                    <?php if (has_post_thumbnail()) { ?>
                                        <img src="<?php echo get_the_post_thumbnail_url(); ?>"
                                             alt="<?php the_title(); ?>">
                                    <?php } ?>
                                </a>
                                <div class="content">
                                    <h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?> </a>
                                    </h5>

                                    <div class="meta fix">
                                    <span class="meta-item date"><i
                                                class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php
                    }
                    $i++;
                }
                wp_reset_postdata();
            }
            ?>
            <?php echo $args['after_widget'];
        }

        /**
         * Back-end widget form.
         */
        public function form($instance)
        {
            $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Top News', 'newsmania');
            $noOfPost = !empty($instance['noOfPost']) ? $instance['noOfPost'] : 3;
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                    <?php esc_html_e('Title :', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('noOfPost')); ?>">
                    <?php esc_html_e('Number of posts to show :', 'newsmania'); ?>
                </label>
                <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('noOfPost')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('noOfPost')); ?>" type="number"
                       value="<?php echo esc_attr($noOfPost); ?>" step="1" min="1" size="3">
            </p>
            <?php
        }

        /**
         * Sanitize widget form values as they are saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : esc_html__('Recent posts', 'newsmania');
            $instance['noOfPost'] = (!empty($new_instance['noOfPost'])) ? strip_tags($new_instance['noOfPost']) : 3;

            return $instance;
        }
    }

// register text-domain_post_widget widget
    if (!function_exists('newsmania_recentpost_widget')) {
        add_action('widgets_init', 'newsmania_recentpost_widget');
        function newsmania_recentpost_widget()
        {
            register_widget("newsmania_recentpost_widget");
        }
    }
}