<?php
if (!class_exists('newsmania_banner_widget')) {
    class newsmania_banner_widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'newsmania_banner_widget',
                esc_html__('Newsmania_banner_widget', 'newsmania'),
                array('description' => esc_html__('selectbanner',
                    'newsmania'))
            );
        }

        public function widget($args, $instance)
        {
            echo $args['before_widget'];?>
            <a class="sidebar-banner"><img src="<?php echo esc_url($instance['Image']) ?>"
                                           alt="<?php esc_html_e('image', 'newsmania');?>"></a>
            <?php
            echo $args['after_widget'];
        }

        public function form($instance)
        {
            $Image = !empty($instance['Image']) ? $instance['Image'] : '';
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('Image')); ?>">
                    <?php esc_html_e('Image:', 'newsmania'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('Image')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('Image')); ?>" type="text"
                       value="<?php echo esc_attr($Image); ?>">
                <span
                    class="description"><?php _e('Upload a image from media uploader and paste the url here.', 'newsmania'); ?></span>
            </p>
        <?php }

        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['Image'] = (!empty($new_instance['Image'])) ? strip_tags($new_instance['Image']) : '';

            return $instance;
        }
    }

    add_action('widgets_init', 'newsmania_banner_widget');
    function newsmania_banner_widget()
    {
        register_widget("newsmania_banner_widget");


    }
}
?>