<?php

class Elementor_contact_us_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'contact_us';
    }

    public function get_title()
    {
        return __('Contact Us', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-mail';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'block_section',
            array(
                'label' => __('Block', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Contact Information',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'block1_section',
            array(
                'label' => __('Block1', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title1',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Email',
            )
        );
        $this->add_control(
            'item_description',
            array(
                'label' => __('Description', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => __('contact@newsmania.com', 'newsmania'),
                'placeholder' => __('Type your description here', 'newsmania'),
            )
        );
        $this->add_control(
            'icon',
            array(
                'label' => __('Icons', 'newsmania'),
                'type' => \Elementor\Controls_Manager::ICON,
                'option' => \Elementor\Control_Icon::get_icons(),
                'default' => 'fa fa-envelope-o',
            )
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'block2_section',
            array(
                'label' => __('Block2', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title2',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Working hours',
            )
        );
        $this->add_control(
            'item_description1',
            array(
                'label' => __('Description', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => __('Mon-Sat: 08 AM – 06 PM', 'newsmania'),
                'placeholder' => __('Type your description here', 'newsmania'),
            )
        );
        $this->add_control(
            'icon1',
            array(
                'label' => __(' Icons', 'newsmania'),
                'type' => \Elementor\Controls_Manager::ICON,
                'option' => \Elementor\Control_Icon::get_icons(),
                'default' => 'fa fa-clock-o',
            )
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'block3_section',
            array(
                'label' => __('Block3', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title3',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Address',
            )
        );
        $this->add_control(
            'item_description2',
            array(
                'label' => __('Description', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => __('41 Union StBoston, MA 02108', 'newsmania'),
                'placeholder' => __('Type your description here', 'newsmania'),
            )
        );
        $this->add_control(
            'icon2',
            array(
                'label' => __(' Icons', 'newsmania'),
                'type' => \Elementor\Controls_Manager::ICON,
                'option' => \Elementor\Control_Icon::get_icons(),
                'default' => 'fa fa-map-marker',
            )
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'block4_section',
            array(
                'label' => __('Block4', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title4',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Phone',
            )
        );


        $this->add_control(
            'item_description3',
            array(
                'label' => __('Description', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => __('+99 235 854 855', 'newsmania'),
                'placeholder' => __('Type your description here', 'newsmania'),
            )
        );


        $this->add_control(
            'icon3',
            array(
                'label' => __('Icons', 'newsmania'),
                'type' => \Elementor\Controls_Manager::ICON,
                'option' => \Elementor\Control_Icon::get_icons(),
                'default' => 'fa fa-phone',
            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $contactid = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo  $contactid; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo   $contactid; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }
        </style>
        <!-- Post Section Start -->
        <div class="post-section clearfix ">
            <!-- Feature Post Row Start -->
            <div class="row">
                <div class="col-12">
                    <!-- Post Block Wrapper Start -->
                    <div class="post-block-wrapper mb-0">

                        <!-- Post Block Head Start -->
                        <div class="head">
                            <!-- Title -->
                            <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
                        </div>
                        <div class="simple-line <?php echo $contactid; ?>"></div>
                        <!-- Post Block Head End -->

                        <!-- Post Block Body Start -->
                        <div class="body">
                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="contact_info">
                                        <?php echo '<i class="' . $settings['icon'] . '" aria-hidden="true"></i>'?>
                                        <div class="contact_info_content">
                                            <?php echo '<div class="content_title1">' . $settings['title1'] . '</div>'?>
                                            <?php echo ' <div class="content_text">' . $settings['item_description'] . '</div>'?>
                                        </div>
                                    </div>
                                    <div class="contact_info">
                                        <?php echo '<i class="' . $settings['icon1'] . '" aria-hidden="true"></i>'?>
                                        <div class="contact_info_content">
                                            <?php echo '<div class="content_title2">' . $settings['title2'] . '</div>'?>
                                            <?php echo ' <div class="content_text">' . $settings['item_description1'] . '</div>'?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="contact_info">
                                        <?php echo '<i class="' . $settings['icon2'] . '" aria-hidden="true"></i>'?>

                                        <div class="contact_info_content">
                                            <?php echo '<div class="content_title3">' . $settings['title3'] . '</div>'?>
                                            <?php echo ' <div class="content_text">' . $settings['item_description2'] . '</div>'?>
                                        </div>
                                    </div>
                                    <div class="contact_info">
                                        <?php echo '<i class="' . $settings['icon3'] . '" aria-hidden="true"></i>'?>
                                        <div class="contact_info_content">
                                            <?php echo '<div class="content_title4">' . $settings['title4'] . '</div>'?>
                                            <?php echo ' <div class="content_text">' . $settings['item_description3'] . '</div>'?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Post Block Body End -->
                    </div>
                    <!-- Post Block Wrapper End -->
                </div>
            </div>
        </div>

    <?php
    }
}