<?php

class Elementor_cat_block_5_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'cat_block_5';
    }

    public function get_title()
    {
        return __('Categories Block 5', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no. of post', 'newsmania'),
                'default' => '8',
            )
        );

        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );
        $cats = get_categories();
        $arr = array();
        foreach ($cats as $cat) {
            $arr[$cat->cat_ID] = $cat->cat_name;
        }
        $this->add_control(
            'selectcate',
            array(
                'label' => __('select categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT,

                'options' => $arr
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $last_id = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo $last_id; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo  $last_id; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post.life-style-post .content .title a.<?php echo  $last_id; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post-block-carousel.education-post-carousel.<?php echo  $last_id; ?> .slick-arrow:hover {

                background: <?php echo $settings['linecolor'];?> !important;
                border-color: <?php echo $settings['linecolor'];?> !important;
            }
        </style>

        <!-- Single Sidebar -->
        <div class="clearfix">
            <div class="sidebar-block-wrapper">
                <!-- Sidebar Block Head Start -->
                <div class="head">

                    <!-- Title -->
                    <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
                </div>
                <!-- Sidebar Block Head End -->
                <div class="simple-line line-life-style <?php echo $last_id; ?>"></div>
                <!-- Sidebar Block Body Start -->
                <div class="body">
                    <!-- Sidebar Post Slider Start -->
                    <?php
                    $arr = array('posts_per_page' => $settings['number'],
                        'cat' => $settings['selectcate']
                    );
                    $posts = new WP_Query($arr);
                    if ($posts->have_posts()) {
                        $i = 0; ?>
                        <div
                            class="four-row-post-carousel row-post-carousel post-block-carousel education-post-carousel <?php echo $last_id; ?>">
                            <?php while ($posts->have_posts()) {
                                $posts->the_post();
                                if ($i < $settings['number']) { ?>
                                    <!-- Small Post Start -->
                                    <div class="post post-small post-list life-style-post ?>">
                                        <div class="post-wrap">
                                            <!-- Image -->
                                            <a class="image"
                                               href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>
                                                    <?php the_post_thumbnail('newsmania-elementor-lastest-cat2'); ?>
                                                <?php } else {
                                                    ?>
                                                    <img
                                                        src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                <?php } ?></a>
                                            <!-- Content -->
                                            <div class="content">

                                                <!-- Title -->
                                                <h5 class="title"><a class="<?php echo $last_id; ?>"
                                                                     href="<?php the_permalink(); ?>">
                                                        <?php the_title(); ?></a></h5>

                                                <!-- Meta -->
                                                <div class="meta fix">
                                                <span class="meta-item date"><i
                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php }
                                $i++;
                            }
                            wp_reset_postdata(); ?>
                            <!-- Small Post End -->
                        </div>
                        <!-- Sidebar Post Slider End -->
                    <?php
                    }?>
                </div>
                <!-- Sidebar Block Body End -->
            </div>
        </div>
    <?php
    }
}

?>