<?php

class Elementor_cat_block_4_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'cat_block_4';
    }

    public function get_title()
    {
        return __('Categories Block 4', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no.post', 'newsmania'),
                'default' => '8',
            )
        );
        $cats = get_categories();
        $arr = array();
        foreach ($cats as $cat) {
            $arr[$cat->cat_ID] = $cat->cat_name;
        }

        $this->add_control(
            'selectcate',
            array(
                'label' => __('select categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT,

                'options' => $arr
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $trending_id = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo  $trending_id; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo  $trending_id; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post .post-wrap .category.<?php echo  $trending_id; ?> {
                background-color: <?php echo $settings['linecolor'];?>
            }

            .post.travel-post .content .title a.<?php echo  $trending_id; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post .content .meta a.<?php echo  $trending_id; ?>:hover {

                color: <?php echo $settings['linecolor'];?> !important;
            }
        </style>
        <!-- Life Style Post Start -->
        <div class="post-block-wrapper">
            <!-- Post Block Head Start -->
            <div class="head">
                <!-- Title -->
                <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
            </div>
            <!-- Post Block Head End -->
            <div class="simple-line line-travel <?php echo $trending_id; ?>"></div>
            <!-- Post Block Body Start -->
            <div class="body pb-0">
                <div class="row">
                    <!-- Post Wrapper Start -->
                    <div class="col-md-12">
                        <?php

                        $arr = array('posts_per_page' => $settings['number'],
                            'cat' => $settings['selectcate']
                        );
                        $featured = new WP_Query($arr);
                        if ($featured->have_posts()) {
                            $i = 0;
                            while ($featured->have_posts()) {
                                $featured->the_post();
                                if ($i < $settings['number']) {
                                    if ($i == 0) {

                                        $b = 'post overlay post';
                                    } else {
                                        $b = 'post post';
                                    } ?>


                                    <div class="<?php echo $b; ?>-default-list travel-post">
                                        <div class="post-wrap">

                                            <!-- Image -->
                                            <a class="image"
                                               href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>

                                                    <?php the_post_thumbnail('newsmania-elementor-trending-post'); ?>
                                                <?php } else {
                                                    ?>
                                                    <img
                                                        src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                <?php } ?></a>

                                            <?php if ($i == 0) { ?>
                                                <?php
                                                $cats = get_the_category();
                                                echo '<a class="category  sports ' . $trending_id . '"
                                                     href="' . esc_url(get_category_link($cats[0])) . '">' .
                                                    $cats[0]->cat_name
                                                    . '</a> ';
                                            } ?>
                                            <!-- Content -->
                                            <div class="content">
                                                <!-- Title -->
                                                <h4 class="title"><a class="<?php echo $trending_id; ?>"
                                                                     href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                </h4>
                                                <!-- Meta -->
                                                <div class="meta fix">
                                                    <div class="meta-item">
                                                        <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                        <a class="<?php echo $trending_id; ?>"
                                                           href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                           class="author"><?php the_author(); ?></a>
                                                    </div>
                                                    <div class="meta-item">
                                                        <i class="fa fa-clock-o"></i>
                                                        <span class="date"><?php the_time('j M, Y'); ?></span>
                                                    </div>
                                                    <div class="meta-item">
                                                        <i class="fa fa-comments"></i>
                                                        <span
                                                            class="comment"><?php echo get_comments_number(); ?></span>
                                                    </div>
                                                </div>
                                                <!-- Description -->
                                                <?php echo wp_trim_words((get_the_excerpt()), 18); ?>
                                            </div>

                                        </div>
                                    </div>
                                <?php }
                                $i++;
                            }
                            wp_reset_postdata();

                        } ?>
                    </div>
                    <!-- Post Wrapper End -->
                </div>
            </div>
            <!-- Post Block Body End -->
        </div>
        <!-- Life Style Post End -->
    <?php
    }
} ?>