<?php
class Elementor_cat_block_12_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return ' cat_block_12';
    }

    public function get_title()
    {
        return __('Categories Block 12', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no. of posts', 'newsmania'),
                'default' => '9',
            )
        );

        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );

        $cats = get_categories();
        $arr = array();
        foreach ($cats as $cat) {
            $arr[$cat->cat_ID] = $cat->cat_name;
        }
        $this->add_control(
            'selectcat',
            array(
                'label' => __('Select Categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $arr
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $weeklyid = 'id-'. uniqid();?>
        <style>
            .simple-line.<?php echo  $weeklyid; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo $weeklyid; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }
            .post .post-wrap .category.<?php echo $weeklyid; ?>{
                background-color: <?php echo $settings['linecolor'];?>
            }

            .post-block-wrapper .head .post-block-tab-list.fashion-post-tab-list > li > a.<?php echo $weeklyid; ?>:hover, .post-block-wrapper .head .post-block-tab-list.fashion-post-tab-list > li > a.active.<?php echo  $weeklyid; ?> {
                background-color:<?php echo $settings['linecolor'];?>
            }

            .post-block-wrapper .head .post-block-tab-list.fashion-post-tab-list > li .dropdown-menu li a.<?php echo $weeklyid; ?>:hover, .post-block-wrapper .head .post-block-tab-list.fashion-post-tab-list > li .dropdown-menu li a.active.<?php echo $weeklyid; ?>{
                color:<?php echo $settings['linecolor'];?>
            }
        </style>

        <!-- Post Block Wrapper Start -->
            <div class="post-block-wrapper">
                <!-- Post Block Head Start -->
                <div class="head">
                    <!-- Title -->
                    <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
                    <!-- Tab List Start -->
                    <ul class="post-block-tab-list fashion-post-tab-list nav d-none d-md-block">
                        <?php
                        $lenght = count($settings['selectcat']);
                        for ($i = 0; $i < $lenght; $i++) {
                            if ($i == 4) {
                                break;
                            }
                            ?>
                            <li>
                                <a class="<?php echo $i == 0 ? 'active '  : ''; echo  $weeklyid; ?>" data-toggle="tab"
                                   href="#trend-cat-<?php echo $i ?>"><?php echo get_category($settings['selectcat'][$i])->cat_name ?></a>
                            </li>

                        <?php }
                        if ($lenght > 4) {
                            ?>
                            <li>
                                <a class="dropdown-toggle <?php echo $weeklyid; ?>" data-toggle="dropdown"
                                   href="#"><?php esc_html_e('More', 'newsmania'); ?></a>
                                <!-- Dropdown -->
                                <ul class="dropdown-menu">
                                    <?php
                                    for ($i = 4; $i < $lenght; $i++) {
                                        ?>
                                        <li>
                                            <a class="<?php echo $weeklyid; ?>" data-toggle="tab"
                                               href="#trend-cat-<?php echo $i ?>"><?php echo get_category($settings['selectcat'][$i])->cat_name ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        <?php } ?>

                   </ul>
                    <!-- Tab List End -->
                    <!-- Tab List Start -->
                    <ul class="post-block-tab-list fashion-post-tab-list nav d-sm-block d-md-none">
                        <li><a class="dropdown-toggle" data-toggle="dropdown" href="#"><?php esc_html_e('Category','newsmania');?></a>

                            <!-- Dropdown -->
                            <ul class="dropdown-menu">
                                <?php
                                $lenght = count($settings['selectcat']);
                                for ($i = 0; $i < $lenght; $i++) {
                                    ?>
                                    <li>
                                        <a class="<?php echo $i == 0 ? 'active' : ''; ?>" data-toggle="tab"
                                           href="#trend-cat-<?php echo $i ?>"><?php echo get_category($settings['selectcat'][$i])->cat_name ?></a>
                                    </li>

                                <?php }?>
                            </ul>

                        </li>
                    </ul>
                    <!-- Tab List End -->
                </div>
                <!-- Post Block Head End -->
                <div class="simple-line line-fashion <?php echo  $weeklyid; ?>"></div>
                <!-- Post Block Body Start -->
                <div class="body pb-0">

                    <!-- Tab Content Start-->
                    <div class="tab-content">
                        <?php
                        for ($i = 0;
                             $i < $lenght;
                             $i++) {
                            $post_ids = array();
                            $active = $i == 0 ? 'show active' : '';
                            ?>
                            <div class="tab-pane fade <?php echo $active?>"
                             id="trend-cat-<?php echo $i ?>">
                                <div class="row">
                                    <div class="col-md-4 col-12">
                                        <?php
                                        $arr = array('posts_per_page' => abs($settings['number']/3),
                                            'category__in' => $settings['selectcat'][$i]
                                        );
                                        $posts = new WP_Query($arr);
                                        if ($posts->have_posts()) {
                                            $j = 0;
                                            while ($posts->have_posts()) {
                                                $posts->the_post();
                                                $post_ids[] = get_the_ID(); ?>
                                                <div class="post overlay mb-20">
                                                    <div class="post-wrap">

                                                        <!-- Image -->
                                                        <div class="image">
                                                            <?php if (has_post_thumbnail()) { ?>
                                                                <?php the_post_thumbnail('newsmania-elementor-home2-weeklypost'); ?>
                                                            <?php } else { ?>
                                                                <img
                                                                    src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                            <?php } ?>
                                                        </div>

                                                        <!-- Category -->
                                                        <?php
                                                        $cats = get_the_category();
                                                        echo '<a class="category education ' .$weeklyid.'"
                                                     href="' . esc_url(get_category_link($cats[0])) . '">' .
                                                            $cats[0]->cat_name
                                                            . '</a> '; ?>

                                                        <!-- Content -->
                                                        <div class="content text-overlay">

                                                            <!-- Title -->
                                                            <h4 class="title"><a
                                                                    href="<?php the_permalink(); ?>">
                                                                    <?php echo wp_trim_words((get_the_title()), 6); ?></a></h4>
                                                            <!-- Meta -->
                                                            <div class="meta fix">
                                                                <span class="meta-item date"><i
                                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php

                                                $j++;
                                            }wp_reset_postdata();
                                        } ?>
                                    </div>
                                    <!-- Post Wrapper End -->
                                    <!-- Post Wrapper Start -->
                                    <div class="col-md-4 col-12">
                                        <?php
                                        $arr = array('posts_per_page' => abs($settings['number']/3),
                                            'category__in' => $settings['selectcat'][$i],
                                            'post__not_in' => $post_ids
                                        );
                                        $posts = new WP_Query($arr);
                                        if ($posts->have_posts()) {
                                            $k = 0;
                                            while ($posts->have_posts()) {
                                                $posts->the_post();
                                                $post_ids[] = get_the_ID();?>

                                                <div class="post overlay mb-20">
                                                    <div class="post-wrap">

                                                        <!-- Image -->
                                                        <div class="image">
                                                            <?php if (has_post_thumbnail()) { ?>
                                                                <?php the_post_thumbnail('newsmania-elementor-home2-weeklypost'); ?>
                                                            <?php } else { ?>
                                                                <img
                                                                    src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                            <?php } ?>
                                                        </div>

                                                        <!-- Category -->
                                                        <?php
                                                        $cats = get_the_category();
                                                        echo '<a class="category education ' .$weeklyid.'"
                                                     href="' . esc_url(get_category_link($cats[0])) . '">' .
                                                            $cats[0]->cat_name
                                                            . '</a> '; ?>

                                                        <!-- Content -->
                                                        <div class="content text-overlay">

                                                            <!-- Title -->
                                                            <h4 class="title"><a
                                                                    href="<?php the_permalink(); ?>">
                                                                    <?php echo wp_trim_words((get_the_title()), 6); ?></a></h4>


                                                            <!-- Meta -->
                                                            <div class="meta fix">
                                                                <span class="meta-item date"><i
                                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                            </div>

                                                        </div>

                                                    </div>
                                                </div>
                                                <?php
                                                $k++;
                                            }
                                        }
                                        wp_reset_postdata(); ?>
                                    </div>
                                    <!-- Post Wrapper End -->
                                    <!-- Post Wrapper Start -->
                                    <div class="col-md-4 col-12">
                                        <?php
                                        $arr = array('posts_per_page' => abs($settings['number']/3),
                                            'category__in' => $settings['selectcat'][$i],
                                            'post__not_in' => $post_ids
                                        );
                                        $posts = new WP_Query($arr);
                                        if ($posts->have_posts()) {
                                            $c = 0;
                                            while ($posts->have_posts()) {
                                                $posts->the_post();?>
                                                <div class="post overlay mb-20">
                                                    <div class="post-wrap">
                                                        <!-- Image -->
                                                        <div class="image">
                                                            <?php if (has_post_thumbnail()) { ?>
                                                                <?php the_post_thumbnail('newsmania-elementor-home2-weeklypost'); ?>
                                                            <?php } else { ?>
                                                                <img
                                                                    src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                            <?php } ?>
                                                        </div>
                                                        <!-- Category -->
                                                        <?php
                                                        $cats = get_the_category();
                                                        echo '<a class="category education ' .$weeklyid.'"
                                                     href="' . esc_url(get_category_link($cats[0])) . '">' .
                                                            $cats[0]->cat_name
                                                            . '</a> '; ?>
                                                        <!-- Content -->
                                                        <div class="content text-overlay">
                                                            <!-- Title -->
                                                            <h4 class="title"><a
                                                                    href="<?php the_permalink(); ?>">
                                                                    <?php echo wp_trim_words((get_the_title()), 6); ?></a></h4>
                                                            <!-- Meta -->
                                                            <div class="meta fix">
                                                                <span class="meta-item date"><i
                                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php
                                                $c++;
                                            }
                                        }
                                        wp_reset_postdata(); ?>
                                    </div>
                                </div>
                            </div><!-- Tab Pane End-->
                        <?php } ?>
                        <!-- Tab Pane Start-->
                    </div>
                    <!-- Tab Content End-->
                </div>
                <!-- Post Block Body End -->
            </div>
            <!-- Post Block Wrapper End -->
    <?php
    }
} ?>