<?php

class Elementor_cat_block_11_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'cat_block_11';
    }

    public function get_title()
    {
        return __('Categories Block 11', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no. of posts', 'newsmania'),
                'default' => '9',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );
        $cats = get_categories();
        $arr = array();
        foreach ($cats as $cat) {
            $arr[$cat->cat_ID] = $cat->cat_name;
        }

        $this->add_control(
            'selectcate',
            array(
                'label' => __('select categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT,

                'options' => $arr
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $trending = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo $trending; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo $trending; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post .post-wrap .content .meta a.<?php echo $trending; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            a.<?php echo $trending; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post-block-carousel.<?php echo $trending; ?> .slick-arrow:hover {

                background: <?php echo $settings['linecolor'];?> !important;
                border-color: <?php echo $settings['linecolor'];?> !important;
            }
        </style>
        <!-- Life Style Post Start -->
        <div class="post-block-wrapper">
            <!-- Post Block Head Start -->
            <div class="head">
                <!-- Title -->
                <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
            </div>
            <!-- Post Block Head End -->
            <div class="simple-line <?php echo $trending;?>"></div>
            <!-- Post Block Body Start -->
            <div class="body">
                <?php
                $arr = array('posts_per_page' => $settings['number'],
                    'cat' => $settings['selectcate']
                );
                $posts = new WP_Query($arr);
                if ($posts->have_posts()) {
                    $i = 0; ?>
                    <div class="three-row-post-carousel row-post-carousel post-block-carousel <?php echo $trending; ?>">
                        <?php while ($posts->have_posts()) {
                            $posts->the_post();
                            if ($i < $settings['number']) { ?>

                                <div class="post post-default-list">
                                    <div class="post-wrap">

                                        <!-- Image -->
                                        <a class="image"
                                           href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>
                                                <?php the_post_thumbnail('newsmania-elementor-home2-trendingpost'); ?>
                                            <?php } else {
                                                ?>
                                                <img
                                                    src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                            <?php } ?></a>
                                        <!-- Content -->
                                        <div class="content">
                                            <!-- Title -->
                                            <h4 class="title"><a class="<?php echo $trending; ?>"
                                                                 href="<?php the_permalink(); ?>">
                                                    <?php the_title(); ?></a></h4>
                                            <!-- Meta -->
                                            <div class="meta fix">
                                                <div class="meta-item">
                                                    <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                    <a class="<?php echo $trending; ?>"
                                                       href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                       class="author"><?php the_author(); ?></a>
                                                </div>
                                                <div class="meta-item">
                                                    <i class="fa fa-clock-o"></i>
                                                    <span class="date"><?php the_time('j M, Y'); ?></span>
                                                </div>
                                            </div>
                                            <!-- Description -->
                                            <?php echo wp_trim_words((get_the_excerpt()), 18); ?><br>
                                            <!-- Read More -->
                                            <a href="<?php the_permalink(); ?>"
                                               class="read-more"><?php esc_html_e('Read more', 'newsmania'); ?></a>
                                        </div>
                                    </div>
                                </div><!-- Post End -->
                            <?php
                            }
                            $i++;
                        }
                        wp_reset_postdata(); ?>
                    </div><!-- Post Block Body End -->
                <?php }?>
            </div>
            <!-- Post Block Wrapper End -->
        </div>
    <?php
    }
} ?>