<?php

class Elementor_cat_block_1_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'cat_block_1';
    }

    public function get_title()
    {
        return __('Categories Block 1', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-gallery-group';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('no. of posts', 'newsmania'),
                'default' => '8',
            )
        );

        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );

        $cats = get_categories();
        $arr1 = array();
        foreach ($cats as $cat) {
            $arr1[$cat->cat_ID] = $cat->cat_name;
        }
        $this->add_control(
            'selectcat',
            array(
                'label' => __('Select Categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $arr1
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $home1id = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo $home1id; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo  $home1id; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post-block-wrapper .head .post-block-tab-list.food-post-tab-list > li > a.<?php echo  $home1id; ?>:hover, .post-block-wrapper .head .post-block-tab-list.food-post-tab-list > li > a.active.<?php echo  $home1id;?> {
                background-color: <?php echo $settings['linecolor'];?>
            }

            .post-block-wrapper .head .post-block-tab-list.food-post-tab-list > li .dropdown-menu li a.<?php echo $home1id; ?>:hover, .post-block-wrapper .head .post-block-tab-list.food-post-tab-list > li .dropdown-menu li a.active.<?php echo  $home1id; ?> {
                color: <?php echo $settings['linecolor'];?>
            }

            .post.food-post .content .title a.<?php echo  $home1id; ?>:hover {
                color: <?php echo $settings['linecolor'];?> !important;
            }

            .post.food-post .content .meta a.<?php echo  $home1id; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }
        </style>
        <!-- Post Section Start -->
        <div class="post-section section">
            <div class="container">
                <div class="row">
                    <div>
                        <!-- Feature Post Start -->
                        <div class="post-block-wrapper">
                            <!-- Post Block Head Start -->
                            <div class="head">
                                <!-- Title -->
                                <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
                                <!-- Tab List Start -->
                                <ul class="post-block-tab-list food-post-tab-list nav d-none d-md-block">
                                    <?php
                                    $lenght = count($settings['selectcat']);
                                    for ($i = 0; $i < $lenght; $i++) {
                                        if ($i == 4) {
                                            break;
                                        }
                                        ?>
                                        <li>
                                            <a class=" <?php echo $i == 0 ? 'active ' : '';
                                            echo $home1id; ?>" data-toggle="tab"
                                               href="#feature-cat-<?php echo $i ?>"><?php echo get_category($settings['selectcat'][$i])->cat_name ?></a>
                                        </li>

                                    <?php }
                                    if ($lenght > 4) {
                                        ?>
                                        <li>
                                            <a class="dropdown-toggle <?php echo $home1id; ?>" data-toggle="dropdown"
                                               href="#"><?php esc_html_e('More', 'newsmania'); ?></a>
                                            <!-- Dropdown -->
                                            <ul class="dropdown-menu">
                                                <?php
                                                for ($i = 4; $i < $lenght; $i++) {
                                                    ?>
                                                    <li>
                                                        <a class="<?php echo $home1id; ?>" data-toggle="tab"
                                                           href="#feature-cat-<?php echo $i ?>"><?php echo get_category($settings['selectcat'][$i])->cat_name ?></a>
                                                    </li>
                                                <?php } ?>
                                            </ul>
                                        </li>
                                    <?php } ?>
                                </ul>
                                <!-- Tab List End -->
                                <!-- Tab List Start -->
                                <ul class="post-block-tab-list food-post-tab-list nav d-sm-block d-md-none">
                                    <li><a class="dropdown-toggle"
                                           data-toggle="dropdown"><?php esc_html_e('Category', 'newsmania');?></a>

                                        <!-- Dropdown -->
                                        <ul class="dropdown-menu">
                                            <?php
                                            $lenght = count($settings['selectcat']);
                                            for ($i = 0; $i < $lenght; $i++) {
                                                ?>
                                                <li>
                                                    <a class="<?php echo $i == 0 ? 'active' : ''; ?>" data-toggle="tab"
                                                       href="#feature-cat-<?php echo $i ?>"><?php echo get_category($settings['selectcat'][$i])->cat_name ?></a>
                                                </li>

                                            <?php }?>
                                        </ul>
                                        <!-- Tab List End -->
                            </div>
                            <!-- Post Block Head End -->
                            <div class="simple-line line-food <?php echo $home1id; ?> "></div>
                            <!-- Post Block Body Start -->
                            <div class="body pb-0">
                                <!-- Tab Content Start-->
                                <div class="tab-content">
                                    <!-- Tab Pane Start-->
                                    <?php
                                    for ($i = 0; $i < $lenght; $i++) {
                                        $active = $i == 0 ? 'show active' : '';
                                        ?>

                                        <div class="tab-pane fade <?php echo $active ?>"
                                             id="feature-cat-<?php echo $i ?>">

                                            <div class="row">
                                                <!-- Post Wrapper Start -->
                                                <div class="col-md-6 col-12">
                                                    <?php
                                                    $arr = array('posts_per_page' => $settings['number'],
                                                        'category__in' => $settings['selectcat'][$i]
                                                    );
                                                    $posts = new WP_Query($arr);
                                                    if ($posts->have_posts()) {
                                                    $j = 0;
                                                    while ($posts->have_posts()) {
                                                    $posts->the_post();

                                                    ?>
                                                    <!-- Post Start -->
                                                    <?php if ($j >= 2) {
                                                        $b = 'post-small post-list food-post post-separator-border';
                                                    } else {
                                                        $b = 'food-post post-separator-border';
                                                    } ?>
                                                    <div class="post <?php echo $b; ?> ">
                                                        <div <?php post_class('post-wrap') ?>>
                                                            <!-- Image -->
                                                            <a class="image"
                                                               href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>
                                                                    <?php the_post_thumbnail($j < 2 ? 'newsmania-elementor-lastest-cat' : 'newsmania-elementor-lastest-cat2'); ?>
                                                                <?php } else {
                                                                    ?>
                                                                    <img
                                                                        src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                                <?php } ?></a>

                                                            <!-- Content -->
                                                            <div class="content">
                                                                <h4 class="title"><a class="<?php echo $home1id; ?>"
                                                                                     href="<?php the_permalink(); ?>">
                                                                        <?php the_title(); ?></a></h4>

                                                                <div class="meta fix">
                                                                    <div class="meta-item">
                                                                        <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                                        <a class="<?php echo $home1id; ?>"
                                                                           href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                                           class="author"><?php the_author(); ?></a>
                                                                    </div>
                                                                    <div class="meta-item">
                                                                        <i class="fa fa-clock-o"></i>
                                                                        <span
                                                                            class="date"><?php the_time('j M, Y'); ?></span>
                                                                    </div>
                                                                    <?php if ($j < 2) { ?>
                                                                        <div class="meta-item">
                                                                            <i class="fa fa-comments"></i>
                                                                            <span
                                                                                class="comment"><?php echo get_comments_number(); ?></span>
                                                                        </div>
                                                                    <?php } ?>
                                                                </div>
                                                                <!-- Description -->
                                                                <?php if ($j < 2) {
                                                                    echo wp_trim_words((get_the_excerpt()), 18);
                                                                } ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- Post End -->

                                                    <!-- Post Wrapper End -->

                                                    <?php
                                                    if ($j == 1) {
                                                    ?>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <?php
                                                    }
                                                    $j++;
                                                    }
                                                    wp_reset_postdata(); ?>
                                                    <?php } ?>
                                                </div>
                                            </div>

                                        </div>
                                    <?php
                                    } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Feature Post End -->
    <?php
    }
}