<?php
get_header();
?>
    <!-- Page Banner Section Start -->
<?php
$arr = get_option('Newsmania');
$breadcrumb = isset($arr['opt-Breadcrumb_header']) ? $arr['opt-Breadcrumb_header'] : '1';
if ($breadcrumb == 1) { ?>
    <div class="page-banner section">
    <?php
    $arr = get_option('Newsmania');
    $image = $arr['opt-background'];
    if (isset($image['url']) && $image['url'] != '') { ?>
        <div class="page-title-wrapper" style="background-image: url(<?php echo $image['url'] ?>);">
    <?php } else {
        ?>
        <div class="page-title-wrapper">
    <?php } ?>
    <div class="container clearfix">
        <h2 class="pull-left title"><?php esc_html_e('Blog', 'newsmania'); ?></h2>
        <!-- breadcrumb -->
        <ol class="breadcrumb pull-right">
            <li class="breadcrumb-item"><a
                    href="<?php echo esc_url(home_url('/')); ?>"><?php esc_html_e('Home', 'newsmania'); ?></a></li>
            <li class="breadcrumb-item active"><?php esc_html_e('Blog', 'newsmania'); ?></a></li>
        </ol>
        <!-- //breadcrumb -->
    </div>
    <!-- //container -->
    </div>
    </div>
<?php } ?>
    <!-- Page Banner Section End -->
    <!-- Blog Section Start -->
    <div class="blog-section section mt-50">
        <div class="container">
            <!-- Feature Post Row Start -->
            <div class="row">
                <?php $side = isset($arr['opt-sidebar_setting']) ? $arr['opt-sidebar_setting'] : 'right';
                if ('left' == $side) { ?>
                    <div class="col-lg-4 col-12 mb-50">
                        <div class="row">
                            <?php get_sidebar(); ?>
                        </div>
                    </div>
                <?php } ?>
                <div class="<?php echo 'hide' == $side ? 'col-lg-12' : 'col-lg-8'; ?> col-lg-8 col-12 mb-50">
                    <?php
                    if (have_posts()) {
                        while (have_posts()) {
                            the_post();
                            ?>
                            <!-- Single Blog Start -->
                            <div class="single-blog mb-50">

                                <div class="blog-wrap">
                                    <!-- Title -->
                                    <h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                    <div class="meta fix">
                                        <?php $cats = get_the_category();
                                        foreach ($cats as $cat) {
                                            echo '<a class="category meta-item" href="' . esc_url(get_category_link($cat)) . '">' . $cat->cat_name . '</a> ';
                                        }?>
                                        <div class="meta-item">
                                            <span> <?php esc_html_e('by', 'newsmania') ?></span>
                                            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                               class="author"><?php the_author(); ?></a>
                                        </div>
                                        <div class="meta-item">
                                            <i class="fa fa-clock-o"></i>
                                            <span class="date"><?php the_time('D, j Y'); ?></span>
                                        </div>
                                    </div>
                                    <!-- Image -->
                                    <?php if (has_post_thumbnail()) { ?>
                                        <a href="<?php the_permalink(); ?>"
                                           class="image"><?php the_post_thumbnail('newsmania-featured-image'); ?></a>
                                    <?php } ?>
                                    <!-- Content -->
                                    <div class="content">
                                        <!-- Description -->
                                        <p><?php the_excerpt(); ?></p>

                                        <!-- Read More -->
                                        <a href="<?php the_permalink(); ?>"
                                           class="read-more"> <?php esc_html_e('Read more', 'newsmania') ?></a>
                                    </div>
                                </div>
                            </div><!-- Single Blog End -->
                        <?php
                        }
                    } else {
                        require(locate_template('template-part/none-content.php'));
                    } ?>
                    <div class="page-pagination-2 text-center">
                        <?php newsmania_pagination(); ?>
                    </div>
                </div>
                <!-- Sidebar Start -->
                <?php if ('right' == $side) { ?>
                    <div class="col-lg-4 col-12 mb-50">
                        <div class="row">
                            <?php get_sidebar(); ?>
                        </div>
                    </div>
                <?php } ?>
                <!-- Sidebar End -->
            </div>
            <!-- Feature Post Row End -->
        </div>
    </div><!-- Blog Section End -->
<?php
get_footer();
?>