<?php

/**
 * ReduxFramework Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */

if (!class_exists('Redux')) {
    return;
}


// This is your option name where all the Redux data is stored.
$opt_name = "Newsmania";

/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name' => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version' => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type' => 'menu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => true,
    // Show the sections below the admin menu item or not
    'menu_title' => __('Newsmania', 'newsmania'),
    'page_title' => __('Newsmania', 'newsmania'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key' => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography' => true,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar' => false,
    // Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-wordpress',
    // Choose an icon for the admin bar menu
    'admin_bar_priority' => 50,
    // Choose an priority for the admin bar menu
    'global_variable' => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode' => false,
    // Show the time the page took to load, etc
    'update_notice' => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

    // OPTIONAL -> Give you extra features
    'page_priority' => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions' => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon' => '',
    // Specify a custom URL to an icon
    'last_tab' => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon' => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug' => '',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults' => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show' => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark' => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time' => 60 * MINUTE_IN_SECONDS,
    'output' => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database' => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn' => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints' => array(
        'icon' => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color' => 'lightgray',
        'icon_size' => 'normal',
        'tip_style' => array(
            'color' => 'red',
            'shadow' => true,
            'rounded' => false,
            'style' => '',
        ),
        'tip_position' => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect' => array(
            'show' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'mouseover',
            ),
            'hide' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'click mouseleave',
            ),
        ),
    )
);
Redux::setArgs($opt_name, $args);
/**
 * customcss section
 */
Redux::setSection($opt_name, array(
    'title' => __('General Settings', 'newsmania'),
    'id' => 'custom',
    'desc' => __(' General Settings', 'newsmania'),
    'customizer_width' => '400px',
    'icon' => 'el el-th',
    'fields' => array(
        array(
            'id' => 'opt-header_preloader',
            'type' => 'switch',
            'title' => __('Preloader', 'newsmania'),
            'on' => __('Enable', 'newsmania'),
            'off' => __('Disable', 'newsmania'),
            'default' => true
        ),
        array(
            'id' => 'opt-custom_primary',
            'type' => 'typography',
            'title' => __('Primary Font', 'newsmania'),
            'subtitle' => __('Specify the primary font properties.', 'newsmania'),
            'google' => true,
            'font-style' => false,
            'font-weight' => false,
            'font-size' => false,
            'subsets' => false,
            'line-height' => false,
            'text-align' => false,
            'color' => false,
            'default' => array(
                'color' => '#dd9933',
                'font-size' => '30px',
                'font-family' => 'open sans,sans-serif',
                'font-weight' => 'Normal',
            ),
        ),
        array(
            'id' => 'opt-custom_secondary',
            'type' => 'typography',
            'title' => __('Secondary Font', 'newsmania'),
            'subtitle' => __('Specify the secondary font properties.', 'newsmania'),
            'google' => true,
            'font-style' => false,
            'font-weight' => false,
            'font-size' => false,
            'subsets' => false,
            'line-height' => false,
            'text-align' => false,
            'color' => false,
            'default' => array(
                'color' => '#dd9933',
                'font-size' => '30px',
                'font-family' => 'Poppins,sans-serif',
                'font-weight' => 'Normal',
            ),
        ),
        array(
            'id' => 'opt-custom_theme',
            'type' => 'color',
            'title' => __('Theme  Color', 'newamania'),
            'default' => '#f44336',
        ),
    )));
/**
 * header section
 */
Redux::setSection($opt_name, array(
    'title' => __('Header section ', 'newsmania'),
    'id' => 'header',
    'desc' => __('header section setting', 'newsmania'),
    'customizer_width' => '400px',
    'icon' => 'el el-th',
    'fields' => array(
        array(
            'id' => 'opt-header_search',
            'type' => 'checkbox',
            'title' => __('Show Search Icon', 'newsmania'),
            'default' => '1'// 1 = on | 0 = off
        ),
        array(
            'id' => 'opt-header_logo',
            'type' => 'media',
            'url' => true,
            'title' => __('Upload Logo Image', 'newsmania'),
            'compiler' => 'true',
            //'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => __('Set Header Logo', 'newsmania'),
            'default' => 'img/lazy.png',
        ))));

/**
 * Home page section
 */
Redux::setSection($opt_name, array(
    'title' => __('Home Settings ', 'newsmania'),
    'id' => 'Home',
    'desc' => __('Home page style', 'newsmania'),
    'customizer_width' => '400px',
    'icon' => 'el el-home',
    'fields' => array(
        /**
         * show breadcrumb header on home page
         */

        array(
            'id' => 'opt-Breadcrumb_header',
            'type' => 'checkbox',
            'title' => __('Breadcrumb Header Shows On Home Page.', 'newsmania'),
            'default' => '1'// 1 = on | 0 = off
        ),
        /**
         * upload image
         */

        array(
            'id' => 'opt-background',
            'type' => 'media',
            'url' => true,
            'title' => __('Upload  Image', 'newsmania'),
            'compiler' => 'true',
            //'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => __('Breadcrumb Background Image', 'newsmania'),
            'default' => '',
            'required' => array('opt-Breadcrumb_header', 'equals', '1'),

        ),

        array(
            'id' => 'opt-sidebar_setting',
            'type' => 'radio',
            'title' => __('Sidebar Position', 'newsmania'),
            //Must provide key => value pairs for radio options
            'options' => array(
                'right' => 'right',
                'left' => 'left',
                'hide' => 'hide'
            ),
            'default' => 'right'
        ),
    )
));

/**
 * Single post page section
 */
Redux::setSection($opt_name, array(
    'title' => __('Single Settings ', 'newsmania'),
    'id' => 'single',
    'desc' => __('Single Page Style', 'newsmania'),
    'customizer_width' => '400px',
    'icon' => 'el el-edit',
    'fields' => array(
        /**
         * show breadcrumb header on single page
         */
        array(
            'id' => 'opt-single_Breadcrumb_header',
            'type' => 'checkbox',
            'title' => __('Breadcrumb Header Shows On Single Page.', 'newsmania'),
            'default' => '1'// 1 = on | 0 = off
        ),
        /**
         * upload image
         */

        array(
            'id' => 'opt-single-background',
            'type' => 'media',
            'url' => true,
            'title' => __('Upload  Image', 'newsmania'),
            'compiler' => 'true',
            //'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => __('Breadcrumb Background Image.', 'newsmania'),
            'default' => '',
            'required' => array('opt-single_Breadcrumb_header', 'equals', '1'),
        ),
        /**
         * Hide all post share icons
         */
        array(
            'id' => 'opt-hide_post_share',
            'type' => 'checkbox',
            'title' => __('Hide All Post Share Icons', 'newsmania'),
            'default' => '0'// 1 = off | 0 = on
        ),
        /**
         * About author
         */
        array(
            'id' => 'opt-hide author_box',
            'type' => 'checkbox',
            'title' => __('Hide About Author Box', 'newsmania'),
            'default' => '0'// 1 = off | 0 = on
        ),
        /**
         * Related posts
         */
        array(
            'id' => 'opt-hide related posts box',
            'type' => 'checkbox',
            'title' => __('Hide Related Posts Box', 'newsmania'),
            'default' => '0'// 1 = off| 0 = on
        ),
        /**
         * Comment box
         */
        array(
            'id' => 'opt-hide comment_box',
            'type' => 'checkbox',
            'title' => __('Hide All Post\'s Comments', 'newsmania'),
            'default' => '0'// 1 = off | 0 = on
        ),
        /**
         * single sidebar
         */
        array(
            'id' => 'opt-single_sidebar_setting',
            'type' => 'radio',
            'title' => __('Sidebar Position', 'newsmania'),
            //Must provide key => value pairs for radio options
            'options' => array(
                'right' => 'right',
                'left' => 'left',
                'hide' => 'hide'
            ),
            'default' => 'right'
        ),
    )
));

/**
 * archive section
 */
Redux::setSection($opt_name, array(
    'title' => __('Archive Settings ', 'newsmania'),
    'id' => 'archive',
    'desc' => __('archive page style', 'newsmania'),
    'customizer_width' => '400px',
    'icon' => 'el el-calendar',
    'fields' => array(
        /**
         * show breadcrumb header on archive page
         */

        array(
            'id' => 'opt-archive_Breadcrumb_header',
            'type' => 'checkbox',
            'title' => __('Breadcrumb Header Shows On Archive Page.', 'newsmania'),
            'default' => '1'// 1 = on | 0 = off
        ),
        /**
         * upload image
         */
        array(
            'id' => 'opt-archive-background',
            'type' => 'media',
            'url' => true,
            'title' => __('Upload  Image', 'newsmania'),
            'compiler' => 'true',
            //'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => __('Breadcrumb Background Image.', 'newsmania'),
            'default' => '',
            'required' => array('opt-archive_Breadcrumb_header', 'equals', '1'),
        ),
        /**
         * archive sidebar
         */
        array(
            'id' => 'opt-archive_sidebar_setting',
            'type' => 'radio',
            'title' => __('Sidebar Position', 'newsmania'),
            //Must provide key => value pairs for radio options
            'options' => array(
                'right' => 'right',
                'left' => 'left',
                'hide' => 'hide'
            ),
            'default' => 'right'
        ),

    )
));

/**
 * Search section
 */

Redux::setSection($opt_name, array(
    'title' => __('Search Settings ', 'newsmania'),
    'id' => 'search',
    'desc' => __('search page style', 'newsmania'),
    'customizer_width' => '400px',
    'icon' => 'el el-search',
    'fields' => array(
        array(
            'id' => 'opt-search_Breadcrumb_header',
            'type' => 'checkbox',
            'title' => __('Breadcrumb Header Shows On Search Page.', 'newsmania'),
            'default' => '1'// 1 = on | 0 = off
        ),
        /**
         * upload image
         */
        array(
            'id' => 'opt-search-background',
            'type' => 'media',
            'url' => true,
            'title' => __('Upload  Image', 'newsmania'),
            'compiler' => 'true',
            //'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => __('Breadcrumb Background Image .', 'newsmania'),
            'default' => '',
            'required' => array('opt-search_Breadcrumb_header', 'equals', '1'),

        ),
        /**
         * search sidebar
         */
        array(
            'id' => 'opt-search_sidebar_setting',
            'type' => 'radio',
            'title' => __('Sidebar Position', 'newsmania'),
            //Must provide key => value pairs for radio options
            'options' => array(
                'right' => 'right',
                'left' => 'left',
                'hide' => 'hide'
            ),
            'default' => 'right'
        ),

    )
));

/**
 * page section
 */

Redux::setSection($opt_name, array(
    'title' => __('Page Settings ', 'newsmania'),
    'id' => 'page',
    'desc' => __('page style', 'newsmania'),
    'customizer_width' => '400px',
    'icon' => 'el el-file',
    'fields' => array(
        array(
            'id' => 'opt-page_Breadcrumb_header',
            'type' => 'checkbox',
            'title' => __('Breadcrumb Header Shows On Page.', 'newsmania'),
            'default' => '1'// 1 = on | 0 = off
        ),
        /**
         * upload image
         */
        array(
            'id' => 'opt-page-background',
            'type' => 'media',
            'url' => true,
            'title' => __('Upload  Image', 'newsmania'),
            'compiler' => 'true',
            //'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => __('Breadcrumb Background Image.', 'newsmania'),
            'default' => '',
            'required' => array('opt-page_Breadcrumb_header', 'equals', '1'),

        ),
        /**
         * Hide all post share icons
         */
        array(
            'id' => 'opt-hide_page_post_share',
            'type' => 'checkbox',
            'title' => __('Hide All Post Share Icons', 'newsmania'),
            'default' => '0'// 1 = off | 0 = on
        ),
        /**
         * About author
         */
        array(
            'id' => 'opt-hide_page_author_box',
            'type' => 'checkbox',
            'title' => __('Hide About Author Box', 'newsmania'),
            'default' => '0'// 1 = off | 0 = on
        ),
        /**
         * Related posts
         */
        array(
            'id' => 'opt-hide_page_related posts box',
            'type' => 'checkbox',
            'title' => __('Hide Related Posts Box', 'newsmania'),
            'default' => '0'// 1 = off| 0 = on
        ),
        /**
         * Comment box
         */
        array(
            'id' => 'opt-hide_page_comment_box',
            'type' => 'checkbox',
            'title' => __('Hide All Post\'s Comments', 'newsmania'),
            'default' => '0'// 1 = off | 0 = on
        ),
        /**
         * page sidebar
         */
        array(
            'id' => 'opt-page_sidebar_setting',
            'type' => 'radio',
            'title' => __('Sidebar Position', 'newsmania'),
            //Must provide key => value pairs for radio options
            'options' => array(
                'right' => 'right',
                'left' => 'left',
                'hide' => 'hide'
            ),
            'default' => 'right'
        ),

    )
));
/**
 * instagram section
 */
Redux::setSection($opt_name, array(
    'title' => __('Instagram Feed ', 'newsmania'),
    'id' => 'instagram',
    'desc' => __('Show Instagram Feed', 'newsmania'),
    'customizer_width' => '400px',
    'icon' => 'el el-instagram',
    'fields' => array(
        /**
         * Instagram username
         */
        array(
            'id' => 'opt-insta_feed',
            'type' => 'switch',
            'title' => __('Show Insta Feed', 'newsmania'),
            'default' => 0,
            'on' => 'Enabled',
            'off' => 'Disabled',
        ),
        array(
            'id' => 'opt-insta_feed_username',
            'type' => 'text',
            'title' => __('Username', 'newsmania'),
            'desc' => __('Just write a single word with lowercase letters. (facebook, twitter, instagram etc. And leave empty for hide it', 'newsmania'),
            'default' => 'instagram',
            'required' => array('opt-insta_feed', 'equals', '1'),
        ),
    )
));


/**
 * Footer section
 */
Redux::setSection($opt_name, array(
    'title' => __('Footer Settings ', 'newsmania'),
    'id' => 'footer',
    'desc' => __('Footer page style', 'newsmania'),
    'customizer_width' => '400px',
    'icon' => 'el el-folder',
    'fields' => array(
        /**
         * Copyright text
         */

        array(
            'id' => 'opt-copy_text',
            'type' => 'text',
            'title' => __('Copyright Text', 'newsmania'),
            'desc' => __('Copyright text', 'newsmania'),
            'default' => 'Powered by <a href="https://codentheme.com/">Codentheme</a> | <a href="https://codentheme.com/free-wordpress-themes/">Free WordPress Themes</a>',
        ),
    )
));