<!doctype html>
<html class="no-js" <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php
    wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php $arr = get_option('Newsmania');
if (isset($arr['opt-header_preloader']) && $arr['opt-header_preloader']) {
    ?>
    <!-- Preloader -->
    <div id="newsmania-preloader">
        <div class="preloader">
            <div class="spinner">
                <div class="bounce1"></div>
                <div class="bounce2"></div>
                <div class="bounce3"></div>
            </div>
        </div>
    </div>
<?php } ?>

<!-- Main Wrapper -->
<div id="main-wrapper">
    <!-- top-bar -->
    <div id="head-top-bar">
        <div class="container">
            <div class="row">
                <div id="logo1" class="col-xs-4 col-sm-3 col-md-3 hidden-sm hidden-xs">
                    <?php

                    $image = isset($arr['opt-header_logo']) ? $arr['opt-header_logo'] : '';
                    if (isset($image['url']) && $image['url'] != '') { ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($image['url']); ?>"
                                                                             alt="logo" width="200px"
                                                                             height="100px"></a>
                    <?php } else { ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img
                                    src="<?php echo get_template_directory_uri() . '/img/logo.png' ?>" alt="logo"></a>
                    <?php } ?>
                </div>
                <!-- //logo -->
                <div class="col-sm-12 col-md-9">
                    <div class="top-right">
                        <?php
                        $search = isset($arr['opt-header_search']) ? $arr['opt-header_search'] : '1';
                        if ($arr['opt-header_search'] == 1) { ?>
                            <div class="head-search">
                                <div class="search-icon-wrapper">
                                    <i class="fa fa-search"></i>
                                </div>
                                <div class="search-wrapper">
                                    <form action="<?php echo esc_url(home_url()) ?>">
                                        <input name="s" maxlength="200" class="inputbox-head-top-search" type="text"
                                               size="20" placeholder="<?php esc_html_e('Search ...', 'newsmania'); ?>">
                                        <i id="search-close" class="fa fa-close"></i>
                                    </form>
                                </div>
                                <!-- //search-wrapper -->
                            </div>
                        <?php } ?>
                        <!-- //search -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- //top-bar -->
    <header class="header">
        <!-- navigation mobile version -->
        <div id="mobile-nav-bar" class="mobile-nav-bar">
            <div class="container">
                <div class="row">
                    <div class="visible-sm visible-xs col-sm-12">
                        <div id="logo" class="mobile-logo pull-left">
                            <?php $image = isset($arr['opt-header_logo']) ? $arr['opt-header_logo'] : '';
                            if (isset($image['url']) && $image['url'] != '') { ?>
                                <a href="<?php echo esc_url(home_url('/')); ?>"><img
                                            src="<?php echo esc_url($image['url']); ?>" alt="logo" width="200px"
                                            height="100px"></a>
                            <?php } else { ?>
                                <a href="<?php echo esc_url(home_url('/')); ?>"><img
                                            src="<?php echo get_template_directory_uri() . '/img/logo.png' ?>"
                                            alt="logo"></a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- navigation -->
        <nav id="navigation-bar" class="navigation">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <?php
                        wp_nav_menu(array(
                            'theme_location' => 'primary',
                            'depth' => 6,
                            'container' => false,
                            'menu_class' => 'list-inline megamenu-parent',
                        ));
                        ?>
                    </div>
                    <!-- col-sm-12 -->
                </div>
                <!-- //row -->
            </div>
            <!-- //container -->
        </nav>
    </header>