<?php

class Elementor_silder_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'slider';
    }

    public function get_title()
    {
        return __('Post Slider Grid', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-post-slider';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,));
        $this->add_control(
            'number',
            array(
                'label' => __('No. of slide', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('No. of slide', 'newsmania'),
                'default' => '8',
            )
        );


        $cats = get_categories();
        $arr1 = array();
        foreach ($cats as $cat) {
            $arr1[$cat->cat_ID] = $cat->cat_name;
        }
        $this->add_control(
            'selectcat',
            array(
                'label' => __('Select Categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $arr1
            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $post_ids = array();
        ?>
        <!-- Hero Section Start -->
        <div class="hero-section section">
        <div class="row">
            <div class="col">
                <div class="row row-1">

                    <div class="order-lg-1 col-lg-6 col-12">
                        <?php
                        $args = array(
                            'posts_per_page' => $settings['number']
                        ,
                            'category__in' => $settings['selectcat']
                        );
                        $featured = new WP_Query($args);
                        if ($featured->have_posts()) { ?>


                            <!-- Hero Post Slider Start -->
                            <div class="post-carousel-1">
                                <?php while ($featured->have_posts()) {
                                    $featured->the_post();
                                    $post_ids[] = get_the_ID();
                                    ?>

                                    <div class="post post-large overlay hero-post">
                                        <div class="post-wrap">

                                            <!-- Image -->
                                            <div class="image"><?php if (has_post_thumbnail()) { ?>
                                                    <?php the_post_thumbnail('newsmania-elementor-slider'); ?>
                                                <?php } else {
                                                    ?>
                                                    <img
                                                        src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                <?php } ?></div>

                                            <!-- Content -->
                                            <div class="content text-overlay">

                                                <!-- Category -->
                                                <?php
                                                $cats = get_the_category();
                                                echo '<a class="category politic" href="' . esc_url(get_category_link($cats[0])) . '">' . $cats[0]->cat_name . '</a> ';
                                                ?>
                                                <!-- Title -->
                                                <h2 class="title"><a
                                                        href="<?php the_permalink(); ?>"><?php the_title(); ?>
                                                    </a></h2>

                                                <!-- Meta -->
                                                <div class="meta fix">
                                                    <div class="meta-item">
                                                        <i class="fa fa-clock-o"></i>
                                                        <span class="date"><?php the_time('j M, Y'); ?></span>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                <?php } ?>
                                <!-- Overlay Post End -->
                            </div>
                            <!-- Hero Post Slider End -->
                        <?php
                        }?>
                    </div>
                    <div class="order-lg-2 col-lg-6 col-12">
                        <div class="row row-1">
                            <?php
                            $arr = array('posts_per_page' => 3,
                                'category__in' => $settings['selectcat'],
                                'post__not_in' => $post_ids);
                            $posts = new WP_Query($arr);
                            if ($posts->have_posts()) {
                                $i = 0;
                                while ($posts->have_posts()) {
                                    $posts->the_post();
                                    if ($i < 3) {
                                        ?>

                                        <!-- Overlay Post Start -->
                                        <?php if ($i == 0) {
                                            $b = 'post overlay hero-post col-lg-12 col-md-12 col-12';
                                        } else {
                                            $b = 'post overlay hero-post col-lg-6 col-md-6 col-12';
                                        }
                                        ?>

                                        <div class="<?php echo $b ?>">
                                            <div class="post-wrap">

                                                <!-- Image -->
                                                <div class="image"><?php if (has_post_thumbnail()) { ?>
                                                        <?php if ($i == 0) {
                                                            the_post_thumbnail('newsmania-elementor-slider-2', array('class' => 'first'));
                                                        } else {
                                                            the_post_thumbnail('newsmania-elementor-slider-3');
                                                        }
                                                    } else {
                                                        ?>
                                                        <?php if ($i == 0) { ?>
                                                            <img
                                                                src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>"
                                                                class="first">
                                                        <?php } else {
                                                            ?>
                                                            <img
                                                                src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                        <?php }

                                                    } ?>
                                                </div>

                                                <!-- Content -->
                                                <div class="content text-overlay">

                                                    <!-- Category -->
                                                    <?php
                                                    $cats = get_the_category();
                                                    echo '<a class="category travel" href="' . esc_url(get_category_link($cats[0])) . '">' . $cats[0]->cat_name . '</a> ';
                                                    ?>

                                                    <!-- Title -->
                                                    <h4 class="title"><a
                                                            href="<?php the_permalink(); ?>"><?php the_title(); ?>
                                                        </a></h4>

                                                    <!-- Meta -->
                                                    <div class="meta fix">
                                                        <div class="meta-item">
                                                            <i class="fa fa-clock-o"></i>
                                                                    <span
                                                                        class="date"><?php the_time('j M, Y'); ?></span>
                                                        </div>
                                                    </div>

                                                </div>

                                            </div>
                                        </div>
                                        <!-- Overlay Post End -->

                                        <!-- Overlay Post Start -->
                                    <?php
                                    }
                                    $i++;
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Breaking News Section Start -->
        </div>
        <!-- Hero Section End -->
    <?php
    }
}

?>