<?php

class  Elementor_slider_1_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'slider_1';
    }

    public function get_title()
    {
        return __('Recent Post Grid', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $cats = get_categories();
        $arr1 = array();
        foreach ($cats as $cat) {
            $arr1[$cat->cat_ID] = $cat->cat_name;
        }
        $this->add_control(
            'selectcat',
            array(
                'label' => __('Select Categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $arr1
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>
        <div class="hero-section section fix">
            <div class="container-fluid p-0">
                <div class="row">
                    <div class="col">
                        <?php
                        $arr = array('posts_per_page' => 5,
                            'category__in' => $settings['selectcat']);
                        $posts = new WP_Query($arr);
                        if ($posts->have_posts()) {
                            $i = 0; ?>
                            <div class="row row-2">
                                <?php while ($posts->have_posts()) {
                                    $posts->the_post();
                                    if ($i < 5) {
                                        if ($i != 2 && $i != 3) {
                                            ?>
                                            <div class="col-lg-4 col-12">
                                            <?php
                                        }
                                    if ($i == 2){
                                        ?>
                                        <div class="row row-2">
                                        <?php
                                    }
                                    if ($i == 2 || $i == 3){
                                        ?>
                                        <div class="col-md-6 col-12">
                                    <?php }
                                        if ($i == 0 || $i == 4) {
                                            $a = "post-large overlay hero-post no-pad";
                                        } else {
                                            $a = "overlay hero-post no-pad";
                                        }
                                        ?>
                                        <div class="post <?php echo $a; ?>">
                                            <div class="post-wrap">
                                                <?php if ($i == 0 || $i == 4) {
                                                    $b = 'newsmania-elementor-home2-slider-1';
                                                } elseif ($i == 1) {
                                                    $b = 'newsmania-elementor-home2-slider-2';
                                                } else {
                                                    $b = 'newsmania-elementor-home2-slider-3';
                                                } ?>
                                                <?php if (has_post_thumbnail()) {
                                                    if (get_post_format() != 'video') { ?>
                                                        <div class="image">
                                                            <?php the_post_thumbnail($b); ?>
                                                        </div>
                                                    <?php }
                                                    if (get_post_format() == 'video') { ?>
                                                        <a href="<?php echo esc_url(get_post_meta(get_the_ID(), '_format_video_embed', true)) ?>"
                                                           class="image video-popup"><?php the_post_thumbnail($b); ?>
                                                            <span class="video-btn"><i
                                                                        class="fa fa-play-circle-o"></i></span>
                                                        </a>
                                                    <?php }
                                                }
                                                $cats = get_the_category();
                                                echo '<a class="category politic" href="' . esc_url(get_category_link($cats[0])) . '">' . $cats[0]->cat_name . '</a> ';
                                                if (get_post_format() != 'video') { ?>
                                                    <div class="content text-overlay">
                                                        <!-- Title -->
                                                        <h2 class="title"><a
                                                                    href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                        </h2>
                                                        <!-- Meta -->
                                                        <div class="meta fix">
                                         <span class="meta-item date"><i
                                                     class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                                <!-- Content -->
                                            </div>
                                        </div>
                                        <!-- Overlay Post End -->
                                        <?php if ($i == 2 || $i == 3){
                                        ?>
                                        </div>
                                    <?php }
                                    if ($i == 3){
                                        ?>
                                        </div>
                                        <?php
                                    }
                                        if ($i < 1 || $i > 2) {
                                            ?>
                                            </div>
                                        <?php } ?>

                                        <?php
                                    }
                                    $i++;
                                }
                                wp_reset_postdata();
                                ?>

                            </div>
                        <?php }
                        ?>
                    </div>
                </div>
            </div>
        </div><!-- Hero Section End -->
        <?php
    }
}

?>