<?php

class Elementor_popular_cat_2_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'popular_cat_2';
    }

    public function get_title()
    {
        return __('Popular Posts List', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-bullet-list';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'popular post',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no. of posts', 'newsmania'),
                'default' => '3',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $popular_id = 'id-' . uniqid(); ?>
        <style>
            .simple-line.<?php echo $popular_id; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo $popular_id; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post.travel-post .content .title a.<?php echo $popular_id; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post.travel-post .content .meta a.<?php echo $popular_id; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }
        </style>
        <div class="sidebar-block-wrapper">
            <!-- Post Block Head Start -->
            <div class="head">
                <!-- Title -->
                <?php echo '<h4 class="title">' . $settings['title'] . '</h4>' ?>
            </div><!-- Post Block Head End -->
            <div class="simple-line line-travel <?php echo $popular_id; ?>"></div>
            <!-- Post Block Body Start -->
            <div class="body">
                <?php
                $arr = array('posts_per_page' => $settings['number'],
                    'orderby' => 'comment_count'
                );
                $posts = new WP_Query($arr);
                if ($posts->have_posts()) {
                    $i = 0;
                    while ($posts->have_posts()) {
                        $posts->the_post();
                        if ($i < $settings['number']) { ?>
                            <!-- Post Start -->
                            <div class="post travel-post post-separator-border border-10">
                                <div class="post-wrap">
                                    <!-- Content -->
                                    <div class="content">
                                        <!-- Title -->
                                        <h4 class="title light"><a class="<?php echo $popular_id; ?>"
                                                                   href="<?php the_permalink(); ?>"><?php the_title(); ?> </a>
                                        </h4>
                                        <!-- Meta -->
                                        <div class="meta fix">
                                            <div class="meta-item">
                                                <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                <a class="<?php echo $popular_id; ?>"
                                                   href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                   class="author"><?php the_author(); ?></a>
                                            </div>
                                            <div class="meta-item">
                                                <i class="fa fa-clock-o"></i>
                                                <span class="date"><?php the_time('j M, Y'); ?></span>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div><!-- Post End -->
                            <?php
                        }
                        $i++;
                    }
                    wp_reset_postdata();
                } ?>

            </div><!-- Post Block Body End -->
        </div>
        </div>
        <?php
    }
} ?>