<?php

class Elementor_popular_cat_1_widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'popular_cat_1';
    }

    public function get_title()
    {
        return __('Popular Posts List', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'popular post',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no. of posts', 'newsmania'),
                'default' => '3',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $editorid = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo   $editorid; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo  $editorid; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post.video-post .content .title a.<?php echo  $editorid; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post.video-post .content .meta a.<?php echo  $editorid; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post-block-carousel.life-style-post-carousel.<?php echo  $editorid; ?> .slick-arrow:hover {
                background: <?php echo $settings['linecolor'];?> !important;
                border-color: <?php echo $settings['linecolor'];?> !important;
            }</style>
        <div>
            <!-- Single Sidebar -->
            <div>
                <!-- Sidebar Block Wrapper -->
                <div class="sidebar-block-wrapper">
                    <!-- Sidebar Block Head Start -->
                    <div class="head">
                        <!-- Title -->
                        <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
                    </div>
                    <!-- Sidebar Block Head End -->
                    <div class="simple-line line-life-style <?php echo $editorid;?>"></div>
                    <!-- Sidebar Block Body Start -->
                    <div class="body">
                        <?php
                        $arr = array('posts_per_page' => $settings['number'],
                            'orderby' => 'comment_count'
                        );
                        $posts = new WP_Query($arr);
                        if ($posts->have_posts()) {
                            $i = 1; ?>
                            <!-- Sidebar Post Slider Start -->
                            <div
                                class="three-row-post-carousel row-post-carousel post-block-carousel life-style-post-carousel <?php echo $editorid; ?>">
                                <?php while ($posts->have_posts()) {
                                    $posts->the_post();
                                    if ($i <= $settings['number']) { ?>

                                        <div class="post video-post post-separator-border">
                                            <div class="post-wrap">
                                                <!-- Image -->
                                                <?php if (($i - 1) % 3 == 0) { ?>
                                                    <a class="image"
                                                       href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>
                                                            <?php the_post_thumbnail('newsmania-elementor-home2-editorpost'); ?>
                                                        <?php } else { ?>
                                                            <img
                                                                src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                        <?php } ?></a>
                                                <?php } ?>
                                                <!-- Content -->
                                                <div class="content">
                                                    <!-- Title -->
                                                    <h4 class="title font-16"><a class="<?php echo $editorid; ?>"
                                                                                 href="<?php the_permalink() ?>"><?php the_title(); ?></a>
                                                    </h4>
                                                    <!-- Meta -->
                                                    <div class="meta fix">
                                                        <div class="meta-item">
                                                            <?php if ($i % 3 == 0) { ?>
                                                                <a class="<?php echo $editorid; ?>"
                                                                   href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                                   class="meta-item author"><i
                                                                        class="fa fa-user"></i> <?php the_author(); ?>
                                                                </a>
                                                            <?php } else { ?>
                                                                <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                                <a class="<?php echo $editorid; ?>"
                                                                   href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                                   class="author"><?php the_author(); ?></a>
                                                            <?php } ?>
                                                        </div>
                                                        <div class="meta-item">
                                                            <?php if ($i % 3 == 0) { ?>
                                                                <span class="meta-item date"> <i
                                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                            <?php } else { ?>
                                                                <i class="fa fa-clock-o"></i>
                                                                <span class="date"><?php the_time('j M, Y'); ?></span>
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div><!-- Post End -->
                                    <?php
                                    }
                                    $i++;
                                }
                                wp_reset_postdata();
                                ?>
                            </div><!-- Sidebar Post Slider End -->
                        <?php
                        }?>
                    </div>
                    <!-- Sidebar Block Body End -->
                </div>
            </div>
        </div>
    <?php
    }
} ?>