<?php

class Elementor_cat_block_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'cat_block';
    }

    public function get_title()
    {
        return __('Categories block', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no of post', 'newsmania'),
                'default' => '3',
            )
        );
        $cats = get_categories();
        $arr = array();
        foreach ($cats as $cat) {
            $arr[$cat->cat_ID] = $cat->cat_name;
        }
        $this->add_control(
            'selectcate',
            array(
                'label' => __('select categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT,

                'options' => $arr
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $fashion_id = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo  $fashion_id; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo  $fashion_id; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post .content .title a.<?php echo  $fashion_id; ?>:hover {

                color: <?php echo $settings['linecolor'];?> !important;
            }

            .post .content a.<?php echo $fashion_id; ?>:hover {
                color: <?php echo $settings['linecolor'];?> !important;
            }
        </style>
        <!-- Post Block Wrapper Start -->
        <div class="post-block-wrapper">
            <!-- Post Block Head Start -->
            <div class="head">
                <!-- Title -->
                <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>
            </div>
            <!-- Post Block Head End -->
            <div class="simple-line line-fashion <?php echo $fashion_id; ?>"></div>
            <!-- Post Block Body Start -->
            <div class="body">
                <?php
                $arr = array('posts_per_page' => $settings['number'],
                    'cat' => $settings['selectcate']
                );
                $posts = new WP_Query($arr);
                if ($posts->have_posts()) {
                    $i = 0;
                    while ($posts->have_posts()) {
                        $posts->the_post();
                        if ($i < $settings['number']) {
                            ?>
                            <!-- Post Start -->
                            <?php if ($i == 0) {
                                $a = "fashion-post post-separator-border";
                            } else {
                                $a = "post-small post-list food-post post-separator-border";
                            } ?>

                            <div class="post <?php echo $a; ?>">
                                <div class="post-wrap">
                                    <!-- Image -->
                                    <a class="image"
                                       href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>
                                            <?php the_post_thumbnail($i == 0 ? 'newsmania-elementor-travel' : 'newsmania-elementor-travel1'); ?>
                                        <?php } else {
                                            ?>
                                            <img
                                                src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                        <?php } ?></a>
                                    <!-- Content -->
                                    <div class="content">
                                        <!-- Title -->
                                        <h4 class="title"><a class="<?php echo $fashion_id; ?>"
                                                             href="<?php the_permalink(); ?>">
                                                <?php the_title(); ?></a></h4>
                                        <!-- Meta -->
                                        <div class="meta fix">
                                            <?php if ($i == 0) { ?>
                                                <a class="meta-item author <?php echo $fashion_id; ?>"
                                                   href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                    ><i
                                                        class="fa fa-user"></i><?php the_author(); ?></a>
                                                <span class="meta-item date"><i
                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                            <?php } else {
                                                ?>
                                                <div class="meta-item">
                                                    <span><?php esc_html_e('by', 'newsmania'); ?></span>
                                                    <a class="author  <?php echo $fashion_id; ?>"
                                                       href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                        ><?php the_author(); ?></a>
                                                </div>
                                            <?php }
                                            if ($i > 0) {
                                                ?>
                                                <div class="meta-item">
                                                    <i class="fa fa-clock-o"></i>
                                                    <span class="date"><?php the_time('j M, Y'); ?></span>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <?php if ($i == 0) {
                                            echo wp_trim_words((get_the_excerpt()), 18);
                                        } ?>

                                    </div>

                                </div>
                            </div><!-- Post End -->
                        <?php
                        }
                        $i++;
                    }
                    wp_reset_postdata();
                }?>
            </div>
            <!-- Post Block Body End -->
        </div>
        <!-- Post Block Wrapper End -->
    <?php
    }
} ?>