<?php

class Elementor_cat_block_3_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'cat_block_3';
    }

    public function get_title()
    {
        return __('Categories Block 3', 'newsmania');
    }

    public function get_icon()
    {
        return 'eicon-posts-group';
    }

    public function get_categories()
    {
        return array('newamania');
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'newsmania'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'title',
            array(
                'label' => __('Title', 'newsmania'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Enter your title', 'newsmania'),
                'default' => 'Categories block',
            )
        );
        $this->add_control(
            'number',
            array(
                'label' => __('no. of posts', 'newsmania'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __('Enter no. of post', 'newsmania'),
                'default' => '9',
            )
        );

        $this->add_control(
            'linecolor',
            array(
                'label' => __('line Color', 'newsmania'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',

            )
        );

        $cats = get_categories();
        $arr1 = array();
        foreach ($cats as $cat) {
            $arr1[$cat->cat_ID] = $cat->cat_name;
        }
        $this->add_control(
            'selectcat',
            array(
                'label' => __('Select Categories', 'newsmania'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $arr1
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $sportid = 'id-' . uniqid();?>
        <style>
            .simple-line.<?php echo  $sportid; ?> {
                border-bottom-color: <?php echo $settings['linecolor'];?> !important;
            }

            .simple-line.<?php echo $sportid; ?>:after {
                border-top-color: <?php echo $settings['linecolor'];?> !important;
            }

            .post-block-wrapper .head .post-block-tab-list.sports-post-tab-list > li > a.<?php echo $sportid; ?>:hover, .post-block-wrapper .head .post-block-tab-list.sports-post-tab-list > li > a.active.<?php echo  $sportid; ?> {
                background-color: <?php echo $settings['linecolor'];?>
            }

            .post-block-wrapper .head .post-block-tab-list.sports-post-tab-list > li .dropdown-menu li a.<?php echo $sportid; ?>:hover, .post-block-wrapper .head .post-block-tab-list.sports-post-tab-list > li .dropdown-menu li a.active.<?php echo $sportid; ?> {
                color: <?php echo $settings['linecolor'];?>
            }

            .post.sports-post .content .title a.<?php echo $sportid; ?>:hover {
                color: <?php echo $settings['linecolor'];?>
            }

            .post .content a.<?php echo $sportid; ?>:hover {
                color: <?php echo $settings['linecolor'];?> !important;
            }

        </style>

        <!-- Sports Post Row Start -->
        <div class="row">

            <div class="col-12">

                <!-- Post Block Wrapper Start -->
                <div class="post-block-wrapper">

                    <!-- Post Block Head Start -->
                    <div class="head">

                        <!-- Title -->
                        <?php echo '<h4 class="title">' . $settings['title'] . '</h4>'?>

                        <!-- Tab List Start -->
                        <ul class="post-block-tab-list sports-post-tab-list nav d-none d-md-block">
                            <?php
                            $lenght = count($settings['selectcat']);
                            for ($i = 0; $i < $lenght; $i++) {
                                if ($i == 4) {
                                    break;
                                }
                                ?>
                                <li>
                                    <a class="<?php echo $i == 0 ? 'active ' : '';
                                    echo $sportid; ?>" data-toggle="tab"
                                       href="#sports-cat-<?php echo $i ?>"><?php echo get_category($settings['selectcat'][$i])->cat_name ?></a>
                                </li>

                            <?php }
                            if ($lenght > 4) { ?>

                                <li><a class="dropdown-toggle <?php echo $sportid; ?>" data-toggle="dropdown"
                                       href="#"><?php esc_html_e('More', 'newsmania'); ?></a>

                                    <!-- Dropdown -->
                                    <ul class="dropdown-menu">
                                        <?php
                                        for ($i = 4; $i < $lenght; $i++) {
                                            ?>
                                            <li>
                                                <a class="<?php echo $sportid; ?>" data-toggle="tab"
                                                   href="#sports-cat-<?php echo $i ?>"><?php echo get_category($settings['selectcat'][$i])->cat_name ?></a>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </li>
                            <?php } ?>
                        </ul>
                        <!-- Tab List End -->

                        <!-- Tab List Start -->
                        <ul class="post-block-tab-list sports-post-tab-list nav d-sm-block d-md-none">
                            <li><a class="dropdown-toggle" data-toggle="dropdown"
                                   href="#"><?php esc_html_e('Category', 'newsmania');?></a>

                                <!-- Dropdown -->
                                <ul class="dropdown-menu">
                                    <?php
                                    for ($i = 0; $i < $lenght; $i++) {
                                        ?>
                                        <li>
                                            <a class="<?php echo $i == 0 ? 'active' : ''; ?>" data-toggle="tab"
                                               href="#sports-cat-<?php echo $i ?>"><?php echo get_category($settings['selectcat'][$i])->cat_name ?></a>
                                        </li>

                                    <?php }?>
                                </ul>
                            </li>
                        </ul>
                        <!-- Tab List End -->
                    </div>
                    <!-- Post Block Head End -->

                    <div class="simple-line line-sports <?php echo $sportid; ?>"></div>

                    <!-- Post Block Body Start -->
                    <div class="body pb-0">

                        <!-- Tab Content Start-->
                        <div class="tab-content">

                            <!-- Tab Pane Start-->
                            <?php
                            for ($i = 0;
                                 $i < $lenght;
                                 $i++) {
                                $post_ids = array();
                                $active = $i == 0 ? 'show active' : '';
                                ?>
                                <div class="tab-pane fade <?php echo $active ?>"
                                     id="sports-cat-<?php echo $i ?>">
                                    <div class="row">

                                        <!-- Overlay Post Wrapper Start -->
                                        <div class="col-lg-8 col-12">
                                            <?php
                                            $arr = array('posts_per_page' => 3,
                                                'category__in' => $settings['selectcat'][$i]
                                            );
                                            $posts = new WP_Query($arr);
                                            if ($posts->have_posts()) {
                                                $j = 0; ?>

                                                <div class="row">
                                                    <?php while ($posts->have_posts()) {
                                                        $posts->the_post();
                                                        $post_ids[] = get_the_ID();
                                                        if ($j == 0) {
                                                            $a = "post-large sports-post col-12 mb-20";
                                                        } else {
                                                            $a = "sports-post col-md-6";
                                                        } ?>
                                                        <!-- Overlay Post Start -->
                                                        <div class="post post-overlay <?php echo $a; ?>">
                                                            <div class="post-wrap">

                                                                <!-- Image -->
                                                                <?php if ($j == 0) {
                                                                    $a = 'newsmania-elementor-sports-news';
                                                                } else {
                                                                    $a = 'newsmania-elementor-sports-news1';
                                                                } ?>
                                                                <?php if (get_post_format() != 'video') { ?>
                                                                <div class="image">
                                                                    <?php }
                                                                    if (has_post_thumbnail()) { ?>
                                                                        <?php if (get_post_format() == 'video') { ?>
                                                                            <a href="<?php echo esc_url(get_post_meta(get_the_ID(), '_format_video_embed', true)) ?>"
                                                                            class="image video-popup">
                                                                        <?php }
                                                                        the_post_thumbnail($a);

                                                                        if (get_post_format() == 'video') { ?>
                                                                            <span class="video-btn"><i
                                                                                    class="fa fa-play"></i></span>
                                                                            </a>
                                                                        <?php } ?>
                                                                    <?php } else { ?>
                                                                        <?php if (get_post_format() == 'video') { ?>
                                                                            <a href="<?php echo esc_url(get_post_meta(get_the_ID(), '_format_video_embed', true)) ?>"
                                                                            class="image video-popup">
                                                                        <?php } ?>
                                                                        <img
                                                                            src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                                        <?php if (get_post_format() == 'video') { ?>
                                                                            <span class="video-btn"><i
                                                                                    class="fa fa-play"></i></span>
                                                                            </a>
                                                                        <?php } ?>

                                                                    <?php } ?>
                                                                    <?php if (get_post_format() != 'video') { ?>
                                                                </div>
                                                            <?php }
                                                            if (get_post_format() != 'video') { ?>
                                                                <div class="content">
                                                                    <!-- Title -->
                                                                    <h2 class="title"><a class="<?php echo $sportid; ?>"
                                                                                         href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                                    </h2>
                                                                    <!-- Meta -->
                                                                    <div class="meta fix">
                                                                        <a class="meta-item author <?php echo $sportid; ?>"
                                                                           href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                                            ><i class="fa fa-user"></i> <?php the_author(); ?>
                                                                        </a>
                                                                <span class="meta-item date"><i
                                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                                    </div>
                                                                </div>
                                                            <?php } ?>

                                                            </div>
                                                        </div>
                                                        <!-- Overlay Post End -->
                                                        <?php
                                                        $j++;
                                                    }
                                                    wp_reset_postdata(); ?>
                                                </div>
                                            <?php
                                            } ?>
                                        </div>

                                        <div class="col-lg-4 col-12">
                                            <?php
                                            $arr = array('posts_per_page' => $settings['number'] - 3,
                                                'cat' => $settings['selectcat'][$i],
                                                'post__not_in' => $post_ids
                                            );
                                            $posts = new WP_Query($arr);
                                            if ($posts->have_posts()) {
                                                $k = 0; ?>
                                                <div class="row">
                                                    <div class="col-lg-12 col-md-6 col-12 mb-20">
                                                        <?php while ($posts->have_posts()) {
                                                            $posts->the_post();
                                                            if ($k != 0) {
                                                                $b = "post-small post-list sports-post post-separator-border";
                                                            } else {
                                                                $b = "sports-post post-separator-border";
                                                            } ?>
                                                            <div class="post <?php echo $b; ?>">
                                                                <div class="post-wrap">

                                                                    <!-- Image -->
                                                                    <a class="image"
                                                                       href="<?php the_permalink(); ?>"><?php if (has_post_thumbnail()) { ?>
                                                                            <?php the_post_thumbnail($k == 0 ? 'newsmania-elementor-sports-news2' : 'newsmania-elementor-sports-news3'); ?>
                                                                        <?php } else {
                                                                            ?>
                                                                            <img
                                                                                src="<?php echo get_template_directory_uri() . '/img/lazy.gif' ?>">
                                                                        <?php } ?></a>

                                                                    <!-- Content -->
                                                                    <div class="content">
                                                                        <?php if ($k > 0) { ?>
                                                                            <h5 class="title"><a
                                                                                    class="<?php echo $sportid; ?>"
                                                                                    href="<?php the_permalink(); ?>">
                                                                                    <?php the_title(); ?> </a></h5>
                                                                        <?php } else {
                                                                            ?>
                                                                            <h4 class="title"><a
                                                                                    class="<?php echo $sportid; ?>"
                                                                                    href="<?php the_permalink(); ?>">
                                                                                    <?php the_title(); ?> </a></h4>
                                                                        <?php } ?>
                                                                        <!-- Meta -->
                                                                        <div class="meta fix">
                                                                            <?php if ($k > 0) { ?>
                                                                                <span class="meta-item date"><i
                                                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                                            <?php } else {
                                                                                ?>
                                                                                <a class="meta-item date <?php echo $sportid; ?> "
                                                                                   href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                                                                                    ><i
                                                                                        class="fa fa-user "></i><?php the_author(); ?>
                                                                                </a>
                                                                                <span class="meta-item date"><i
                                                                                        class="fa fa-clock-o"></i><?php the_time('j M, Y'); ?></span>
                                                                            <?php } ?>
                                                                        </div>
                                                                        <?php if ($k == 0) {
                                                                            echo wp_trim_words((get_the_excerpt()), 18);
                                                                        } ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <?php
                                                            $k++;
                                                        }
                                                        wp_reset_postdata();
                                                        ?>
                                                    </div>

                                                </div>
                                            <?php
                                            } ?>
                                        </div>
                                        <!-- Post Wrapper End -->

                                    </div>

                                </div>
                            <?php }?>
                            <!-- Tab Pane End-->
                        </div>
                        <!-- Tab Content End-->
                    </div>
                    <!-- Post Block Body End -->
                </div>
                <!-- Post Block Wrapper End -->
            </div>
        </div>
        <!-- Sports Post Row End -->
    <?php
    }
} ?>