<?php
/* Redux */
if (class_exists('ReduxFramework')) {
    require_once get_template_directory() . '/inc/redux-setting.php';
}

/**
 * Retrive Google fonts
 */
if (!function_exists('newsmania_fonts_url')) {
    function newsmania_fonts_url()
    {
        $fonts_url = '';

        $OpenSans = _x('on', 'Open Sans font: on or off', 'newsmania');

        $Poppins = _x('on', 'Poppins font: on or off', 'newsmania');

        if ('off' !== $Poppins || 'off' !== $OpenSans) {
            $font_families = array();

            if ('off' !== $Poppins) {
                $font_families[] = 'Poppins:300,400,500,600,700,800';
            }

            if ('off' !== $OpenSans) {
                $font_families[] = 'Open Sans:300,400,600,700,800';
            }

            $query_args = array(
                'family' => urlencode(implode('|', $font_families)),
                'subset' => urlencode('latin,latin-ext'),
            );

            $fonts_url = add_query_arg($query_args, '//fonts.googleapis.com/css');
        }

        return esc_url_raw($fonts_url);
    }
}


/**
 * enqueue script
 */
if (!function_exists('newsmania_enqueue_scripts')) {
    add_action('wp_enqueue_scripts', 'newsmania_enqueue_scripts');
    function newsmania_enqueue_scripts()
    {
// enqueue css files
        wp_enqueue_style('google-font', newsmania_fonts_url());
        wp_enqueue_style('bootstrap-css', get_template_directory_uri() . '/css/bootstrap.min.css', array(), '1.0');
        wp_enqueue_style('font-awesome-css', get_template_directory_uri() . '/css/font-awesome.min.css', array(), '1.0');
        wp_enqueue_style('plugins-css', get_template_directory_uri() . '/css/plugins.css', array(), '1.0');
        wp_enqueue_style('style-css', get_template_directory_uri() . '/style.css', array(), '1.0');

// enqueue js files
        wp_enqueue_script('modernizr-2-8-3-min-script', get_template_directory_uri() . '/js/vendor/modernizr-2.8.3.min.js', array('jquery'), '1.0', true);
        wp_enqueue_script('popper-min-script', get_template_directory_uri() . '/js/popper.min.js', array('jquery'), '1.0', true);
        wp_enqueue_script('bootstrap-min-script', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), '1.0', true);
        wp_enqueue_script('plugins-script', get_template_directory_uri() . '/js/plugins.js', array('jquery'), '1.0', true);
        wp_enqueue_script('jquery-carouFredSel', get_template_directory_uri() . '/js/jquery.carouFredSel-6.2.1.js', array('jquery'), '1.0', true);
        wp_enqueue_script('main-script', get_template_directory_uri() . '/js/main.js', array('jquery'), '1.0', true);
        // comment reply script
        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
    }
}
/**
 * Theme setup
 */
if (!function_exists('Newsmania_setup_theme')) {
    add_action('after_setup_theme', 'Newsmania_setup_theme');
    function Newsmania_setup_theme()
    {
        add_theme_support('title-tag');
        add_theme_support('automatic-feed-links');

        load_theme_textdomain('newsmania', get_template_directory() . '/languages');

        add_theme_support('post-thumbnails');
        add_image_size('newsmania-featured-image', 568, 311, true);
        add_image_size('newsmania-thumbnail-image', 290, 254, true);
        add_image_size('newsmania-thumbnail-avatar', 88, 88, true);
        add_image_size('newsmania-single-image', 290, 254, true);
        add_image_size('newsmania-categories-image', 290, 180, true);
        add_image_size('newsmania-elementor-image', 464, 353, true);
        add_image_size('newsmania-elementor-image2', 464, 221, true);
        add_image_size('newsmania-elementor-image3', 231, 175, true);
        add_image_size('newsmania-elementor-popular-view', 384, 291, true);
        add_image_size('newsmania-elementor-lastest-cat', 290, 173, true);
        add_image_size('newsmania-elementor-lastest-cat2', 100, 76, true);
        add_image_size('newsmania-elementor-cat-post', 130, 77, true);
        add_image_size('newsmania-elementor-trending-post', 300, 180, true);
        add_image_size('newsmania-elementor-sports-news', 770, 462, true);
        add_image_size('newsmania-elementor-sports-news1', 370, 260, true);
        add_image_size('newsmania-elementor-sports-news2', 290, 177, true);
        add_image_size('newsmania-elementor-sports-news3', 100, 76, true);
        add_image_size('newsmania-elementor-travel', 290, 211, true);
        add_image_size('newsmania-elementor-travel1', 100, 76, true);
        add_image_size('newsmania-elementor-home2-slider-1', 450, 394, true);
        add_image_size('newsmania-elementor-home2-slider-2', 450, 197, true);
        add_image_size('newsmania-elementor-home2-slider-3', 226, 198, true);
        add_image_size('newsmania-elementor-home2-fashion', 290, 188, true);
        add_image_size('newsmania-elementor-home2-fashion2', 100, 76, true);
        add_image_size('newsmania-elementor-home2-lifestyle', 610, 322, true);
        add_image_size('newsmania-elementor-home2-cat', 370, 222, true);
        add_image_size('newsmania-elementor-home2-trendingpost', 300, 200, true);
        add_image_size('newsmania-elementor-home2-weeklypost', 183, 160, true);
        add_image_size('newsmania-elementor-home2-editorpost', 290, 213, true);
        add_image_size('newsmania-elementor-home3-slider', 242, 362, true);
        add_image_size('newsmania-elementor-home3-catpost', 210, 159, true);
        add_image_size('newsmania-elementor-slider', 584, 444, true);
        add_image_size('newsmania-elementor-slider-2', 584, 221, true);
        add_image_size('newsmania-elementor-slider-3', 291, 221, true);
        add_image_size('newsmania-content-single', 1200, 800, true);
        add_image_size('newsmania-elementor-block-16-1', 770, 349, true);
        add_image_size('newsmania-elementor-block-16-2', 90, 64, true);
        add_theme_support('post-formats',
            array(
                'gallery',
                'video',
                'audio',
            )
        );
        register_nav_menus(array('primary' => esc_html__('primary', 'newsmania')));

        add_theme_support('html5', array(
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ));
    }
}

if (!isset($content_width)) $content_width = 900;
/**
 * Add Widget Areas
 */
if (!function_exists('Newsmania_add_widgets')) {
    add_action('widgets_init', 'Newsmania_add_widgets');
    function Newsmania_add_widgets()
    {
        register_sidebar(array(
            'name' => esc_html__('Sidebar', 'newsmania'),
            'id' => 'sidebar',
            'before_widget' => ' <div class="single-sidebar col-lg-12 col-md-6 col-12"><div class="sidebar-block-wrapper">',
            'after_widget' => '</div></div>',
            'before_title' => '<div class="head"><h4 class="title">',
            'after_title' => '</h4></div><div class="simple-line"></div>',
        ));

        register_sidebar(array(
            'name' => esc_html__('Footer-1', 'newsmania'),
            'id' => 'footer-1',
            'before_widget' => '<aside id="%1$s"  class="%2$s widget fs--widget">',
            'after_widget' => '</aside>',
            'before_title' => '<div class="fs--widget--title"><h4>',
            'after_title' => '</h4></div>',
        ));

        register_sidebar(array(
            'name' => esc_html__('Footer-2', 'newsmania'),
            'id' => 'footer-2',
            'before_widget' => '<aside id="%1$s"  class="%2$s widget fs--widget">',
            'after_widget' => '</aside>',
            'before_title' => ' <h4 class="widget-title">',
            'after_title' => '</h4>',
        ));

        register_sidebar(array(
            'name' => esc_html__('Footer-3', 'newsmania'),
            'id' => 'footer-3',
            'before_widget' => '<aside id="%1$s"  class="%2$s widget fs--widget">',
            'after_widget' => '</aside>',
            'before_title' => '<h4 class="widget-title">',
            'after_title' => '</h4>',
        ));

        register_sidebar(array(
            'name' => esc_html__('Footer-4', 'newsmania'),
            'id' => 'footer-4',
            'before_widget' => '<aside id="%1$s"  class="%2$s widget fs--widget">',
            'after_widget' => '</aside>',
            'before_title' => ' <h4 class="widget-title">',
            'after_title' => '</h4>',
        ));

    }
}

if (!function_exists('newsmania_pagination')) {
    function newsmania_pagination()
    {
        ?>
        <ul>
            <?php
            global $wp_query;
            $pages = paginate_links(array(
                    'base' => str_replace(1e6, '%#%', esc_url(get_pagenum_link(1e6))),
                    'format' => '?paged=%#%',
                    'current' => max(1, get_query_var('paged')),
                    'total' => $wp_query->max_num_pages,
                    'prev_next' => true,
                    'prev_text' => '<i class="fa fa-angle-left"></i>',
                    'next_text' => '<i class="fa fa-angle-right"></i>',
                    'type' => 'array',
                )
            );
            if (is_array($pages))
                foreach ($pages as $page) {
                    $class = strpos($page, 'current') ? 'class="active"' : '';
                    echo '<li ' . $class . '>' . $page . '</li> ';
                }
            ?>
        </ul>
    <?php }
}
/**
 * TGMA plugin
 */
require_once get_template_directory() . '/plugins/class-tgm-plugin.php';

if (!function_exists('newsmania_register_required_plugins')) {
    add_action('tgmpa_register', 'newsmania_register_required_plugins');
    function newsmania_register_required_plugins()
    {

        $plugins = array(
            array(
                'name' => 'MailChimp for WordPress',
                'slug' => 'mailchimp-for-wp',
                'required' => false,
                'version' => '4.1.1',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => ''
            ),
            array(
                'name' => 'Newsmania Social Share Plugin',
                'slug' => 'newsmania-social-share',
                'source' => get_template_directory() . '/plugins/newsmania-social-share.zip',
                'required' => true,
                'version' => '1.0',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),

            array(
                'name' => 'Vafpress Post Formats UI',
                'slug' => 'vafpress-post-formats-ui-develop',
                'source' => get_template_directory() . '/plugins/vafpress-post-formats-ui.zip',
                'required' => true,
                'version' => '1.5',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => 'WP Mega Menu',
                'slug' => 'wp-megamenu',
                'required' => true,
                'version' => '1.1.9',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => 'Regenerate Thumbnails',
                'slug' => 'regenerate-thumbnails',
                'required' => true,
                'version' => '3.0.2',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => 'Redux Framework',
                'slug' => 'redux-framework',
                'required' => true,
                'version' => '3.6.9',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => 'Elementor',
                'slug' => 'elementor',
                'required' => true,
                'version' => '2.0.16',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => 'AccessPress Social Counter',
                'slug' => 'accesspress-social-counter',
                'required' => true,
                'version' => '1.7.5',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => 'Contact Form 7',
                'slug' => 'contact-form-7',
                'required' => true,
                'version' => '5.0.3',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => 'One Click Demo Import',
                'slug' => 'one-click-demo-import',
                'required' => true,
                'version' => '2.5.0',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            )

        );

        $config = array(
            'id' => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
            'default_path' => '',                      // Default absolute path to pre-packaged plugins.
            'menu' => 'tgmpa-install-plugins', // Menu slug.
            'parent_slug' => 'themes.php',            // Parent menu slug.
            'capability' => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
            'has_notices' => true,                    // Show admin notices or not.
            'dismissable' => true,                    // If false, a user cannot dismiss the nag message.
            'dismiss_msg' => '',                      // If 'dismissable' is false, this message will be output at top of nag.
            'is_automatic' => true,                   // Automatically activate plugins after installation or not.
            'message' => '',                      // Message to output right before the plugins table.
            'strings' => array(
                'page_title' => esc_html__('Install Required Plugins', 'newsmania'),
                'menu_title' => esc_html__('Install Plugins', 'newsmania'),
                'installing' => esc_html__('Installing Plugin: %s', 'newsmania'), // %s = plugin name.
                'oops' => esc_html__('Something went wrong with the plugin API.', 'newsmania'),
                'notice_can_install_required' => _n_noop(
                    'This theme requires the following plugin: %1$s.',
                    'This theme requires the following plugins: %1$s.',
                    'newsmania'
                ), // %1$s = plugin name(s).
                'notice_can_install_recommended' => _n_noop(
                    'This theme recommends the following plugin: %1$s.',
                    'This theme recommends the following plugins: %1$s.',
                    'newsmania'
                ), // %1$s = plugin name(s).
                'notice_cannot_install' => _n_noop(
                    'Sorry, but you do not have the correct permissions to install the %1$s plugin.',
                    'Sorry, but you do not have the correct permissions to install the %1$s plugins.',
                    'newsmania'
                ), // %1$s = plugin name(s).
                'notice_ask_to_update' => _n_noop(
                    'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.',
                    'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.',
                    'newsmania'
                ), // %1$s = plugin name(s).
                'notice_ask_to_update_maybe' => _n_noop(
                    'There is an update available for: %1$s.',
                    'There are updates available for the following plugins: %1$s.',
                    'newsmania'
                ), // %1$s = plugin name(s).
                'notice_cannot_update' => _n_noop(
                    'Sorry, but you do not have the correct permissions to update the %1$s plugin.',
                    'Sorry, but you do not have the correct permissions to update the %1$s plugins.',
                    'newsmania'
                ), // %1$s = plugin name(s).
                'notice_can_activate_required' => _n_noop(
                    'The following required plugin is currently inactive: %1$s.',
                    'The following required plugins are currently inactive: %1$s.',
                    'newsmania'
                ), // %1$s = plugin name(s).
                'notice_can_activate_recommended' => _n_noop(
                    'The following recommended plugin is currently inactive: %1$s.',
                    'The following recommended plugins are currently inactive: %1$s.',
                    'newsmania'
                ), // %1$s = plugin name(s).
                'notice_cannot_activate' => _n_noop(
                    'Sorry, but you do not have the correct permissions to activate the %1$s plugin.',
                    'Sorry, but you do not have the correct permissions to activate the %1$s plugins.',
                    'newsmania'
                ), // %1$s = plugin name(s).
                'install_link' => _n_noop(
                    'Begin installing plugin',
                    'Begin installing plugins',
                    'newsmania'
                ),
                'update_link' => _n_noop(
                    'Begin updating plugin',
                    'Begin updating plugins',
                    'newsmania'
                ),
                'activate_link' => _n_noop(
                    'Begin activating plugin',
                    'Begin activating plugins',
                    'newsmania'
                ),
                'return' => esc_html__('Return to Required Plugins Installer', 'newsmania'),
                'plugin_activated' => esc_html__('Plugin activated successfully.', 'newsmania'),
                'activated_successfully' => esc_html__('The following plugin was activated successfully:', 'newsmania'),
                'plugin_already_active' => esc_html__('No action taken. Plugin %1$s was already active.', 'newsmania'),  // %1$s = plugin name(s).
                'plugin_needs_higher_version' => esc_html__('Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'newsmania'),  // %1$s = plugin name(s).
                'complete' => esc_html__('All plugins installed and activated successfully. %1$s', 'newsmania'), // %s = dashboard link.
                'contact_admin' => esc_html__('Please contact the administrator of this site for help.', 'newsmania'),

                'nag_type' => 'updated', // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
            )
        );

        tgmpa($plugins, $config);

    }
}
/**
 * Add url in social link
 */
add_filter('user_contactmethods', 'newsmania_social_link', 10, 1);
function newsmania_social_link($contact_methods)
{
    $contact_methods['facebook'] = __('Facebook URL', 'newsmania');
    $contact_methods['twitter'] = __('Twitter URL', 'newsmania');
    $contact_methods['google-plus'] = __('Google-Plus URL', 'newsmania');
    $contact_methods['dribbble'] = __('Dribbble URL', 'newsmania');
    $contact_methods['pinterest'] = __('Pinterest URL', 'newsmania');
    return $contact_methods;
}


/**
 * Add instaform
 */
require_once get_template_directory() . '/inc/newsmania-function-insta.php';

/**
 * Add commentform
 */
require_once get_template_directory() . '/inc/newsmania-comment-box.php';
/**
 * Add popular view
 */
require_once get_template_directory() . '/inc/newsmania-popular-view.php';

/**
 * Add custom css
 */
require_once get_template_directory() . '/inc/customcss.php';

/**
 * Add Widgets
 */
require_once get_template_directory() . '/widget/newsmania-category.php';
require_once get_template_directory() . '/widget/newsmania-about-us-widget.php';
require_once get_template_directory() . '/widget/newsmania-recentpost.php';
require_once get_template_directory() . '/widget/newsmania-banner.php';
require_once get_template_directory() . '/widget/newsmania-popularpost.php';


/**
 * Add elementor Widgets
 */
if (!function_exists('newsmania_register_widgets')) {
    add_action('elementor/widgets/widgets_registered', 'newsmania_register_widgets');

    function newsmania_register_widgets()
    {
        require get_parent_theme_file_path('/widget/elementor-widget/custom-banner-1-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-banner-2-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-1-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-2-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-3-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-4-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-5-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-6-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-video-block-7-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-8-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-9-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-10-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-11-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-12-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-13-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-14-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-15-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-16-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-cat-block-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-popular-post-1-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-popular-post-2-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-popular-post-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-slider-1-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-slider-2-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-slider-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-ticker-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-contact-us-widget.php');
        require get_parent_theme_file_path('/widget/elementor-widget/custom-title-widget.php');

        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_banner_1_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_banner_2_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_1_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_2_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_3_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_4_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_5_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_6_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_7_Widget ());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_8_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_9_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_10_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_11_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_12_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_13_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_14_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_15_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_16_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_cat_block_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_popular_cat_1_widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_popular_cat_2_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_popular_cat_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_slider_1_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_slider_2_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_silder_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Elementor_ticker_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new  Elementor_contact_us_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new  Elementor_custom_title_Widget());
    }
}

if (!function_exists('newsmania_add_elementor_widget_categories')) {
    function newsmania_add_elementor_widget_categories($elements_manager)
    {

        $elements_manager->add_category(
            'newamania',
            array(
                'title' => __('Newsmania', 'newsmania'),
                'icon' => 'fa fa-plug',
            )
        );
    }

    add_action('elementor/elements/categories_registered', 'newsmania_add_elementor_widget_categories');
}

if(!function_exists('newsmania_import_files')) {
    function newsmania_import_files()
    {
        return array(
            array(
                'import_file_name' => 'Newsmania',
                'categories' => array('Newsmania'),
                'local_import_file' => trailingslashit(get_template_directory()) . 'data/demo-content.xml',
                'local_import_widget_file' => trailingslashit(get_template_directory()) . 'data/widget.wie',
                'local_import_redux' => array(
                    array(
                        'file_path' => trailingslashit(get_template_directory()) . 'data/redux.json',
                        'option_name' => 'Newsmania',
                    ),
                ),
                'import_notice' => __('After you import this demo, you will have to setup the mega menu separately.', 'newsmania'),
                'preview_url' => 'https://bylancer.com/products/wp-newsmania-theme/',
            )
        );
    }

    add_filter('pt-ocdi/import_files', 'newsmania_import_files');
}