<div class="blog-list">
    <?php
    while (have_posts()) {
        the_post(); ?>
        <div <?php post_class('blog-item') ?>>
            <div class="blog-inner">
                <?php if (get_post_format() != '') {
                    get_template_part('template-parts/content', get_post_format());
                } else {
                    if (has_post_thumbnail()) { ?>
                        <a href="<?php the_permalink(); ?>">
                            <div class="blog-img">
                                <div class="overlay"><i class="mdi-link-variant"></i></div>
                                <img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>'"
                                     alt="<?php the_title(); ?>"/>
                            </div>
                        </a>
                    <?php }
                } ?>
                <div class="info">
                    <div class="title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </div>
                    <div class="meta">
                        <ul>
                            <li class="category"><?php
                                $cats = get_the_category();
                                $arr = array();
                                foreach ($cats as $cat) {
                                    $arr[] = '<a href="' . get_category_link($cat) . '">' . $cat->cat_name . '</a>';
                                }
                                echo implode(', ', $arr);
                                ?>
                            </li>
                            <li class="author"><?php esc_html_e('by ', 'electron');
                                echo get_the_author_posts_link(); ?>
                            </li>
                            <li class="date">
                                <a href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>">
                                    <?php the_time('M j, Y'); ?>
                                </a>
                            </li>
                            <li class="comment">
                                <?php echo get_comments_number(); esc_html_e(' comments', 'electron'); ?>
                            </li>
                        </ul>
                    </div>
                    <div class="text">
                        <p>
                            <?php echo wp_trim_words(get_the_excerpt(), 50); ?>
                        </p>
                    </div>
                    <div class="simple-line"></div>
                    <div class="share">
                        <div class="post-bottom">
                            <div class="continue">
                                <a href="<?php the_permalink(); ?>"><?php esc_html_e('Continue Reading', 'electron'); ?>
                                    <span><i class="fa fa-long-arrow-right"></i></span></a>
                            </div>
                            <?php
                            $share_icon = '';
                            if (is_archive()) {
                                $share_icon = 'checkbox_icon_archive_setting';
                            } elseif (is_home()) {
                                $share_icon = 'checkbox_icon_Home_setting';
                            } elseif (is_search()) {
                                $share_icon = 'checkbox_icon_search_setting';
                            }
                            if (get_theme_mod($share_icon, false)) { ?>
                                <div class="share-iocn">
                                    <?php if (function_exists('electron_social_share')) {
                                        ?>
                                        <span class="share"><?php esc_html_e('Share:', 'electron'); ?></span>
                                        <span class="icon">
                                        <?php
                                        electron_social_share();
                                        ?>
                                    </span>
                                        <?php
                                    } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
</div>