<?php
if (!function_exists('electron_get_tweets')) {
    function electron_get_tweets($username, $noOfPosts, $request_settings)
    {
        include_once(get_template_directory() . '/inc/OauthConnect.php');

        $get_fields = array();
        $get_fields['tweet_mode'] = 'extended';
        $get_fields['screen_name'] = $username;
        $get_fields['count'] = $noOfPosts;

        // actual connection
        $twitter_connect = new OauthConnect($request_settings, 'user');
        $twitter_connect->setUrlBase();
        $twitter_connect->setGetFields($get_fields);
        $twitter_connect->setRequestMethod('wp_http');

        return $twitter_connect->performRequest();
    }
}