<?php
if (!function_exists('electron_get_instagram')) {
    function electron_get_instagram($username)
    {
        $username = strtolower($username);
        $username = str_replace('@', '', $username);

        $remote = wp_remote_get('http://instagram.com/' . trim($username));

        if (is_wp_error($remote))
            return new WP_Error('site_down', esc_html__('Unable to communicate with Instagram.', 'electron'));

        if (200 != wp_remote_retrieve_response_code($remote))
            return new WP_Error('invalid_response', esc_html__('Instagram did not return a 200.', 'electron'));

        $shards = explode('window._sharedData = ', $remote['body']);
        $insta_json = explode(';</script>', $shards[1]);
        $insta_array = json_decode($insta_json[0], TRUE);

        if (!$insta_array)
            return new WP_Error('bad_json', esc_html__('Instagram has returned invalid data.', 'electron'));

        if (isset($insta_array['entry_data']['ProfilePage'][0]['graphql']['user']['edge_owner_to_timeline_media']['edges'])) {
            $images = $insta_array['entry_data']['ProfilePage'][0]['graphql']['user']['edge_owner_to_timeline_media']['edges'];
        } else {
            return new WP_Error('bad_json_2', esc_html__('Instagram has returned invalid data.', 'electron'));
        }

        if (isset($insta_array['entry_data']['ProfilePage'][0]['graphql']['user'])) {
            $profile_pic = $insta_array['entry_data']['ProfilePage'][0]['graphql']['user'];
        } else {
            return new WP_Error('bad_json_3', esc_html__('Instagram has returned invalid data.', 'electron'));
        }

        if (!is_array($images))
            return new WP_Error('bad_array', esc_html__('Instagram has returned invalid data.', 'electron'));

        $instagram = array();
        foreach ($images as $image) {
            $image['node']['thumbnail_src'] = preg_replace('/^https?\:/i', '', $image['node']['thumbnail_src']);
            $instagram['images'][] = array(
                'link' => trailingslashit('//instagram.com/p/' . $image['node']['shortcode']),
                'img' => $image['node']['thumbnail_src']
            );
        }

        // do not set an empty transient - should help catch private or empty accounts
        if (array_key_exists('images', $instagram)) {
            $instagram['profile_pic'] = $profile_pic['profile_pic_url'];
            $instagram = base64_encode(serialize($instagram));
        }

        if (!empty($instagram)) {
            return unserialize(base64_decode($instagram));
        } else {
            return new WP_Error('no_images', esc_html__('Instagram did not return any images.', 'electron'));
        }
    }
}