<?php
if (!function_exists('electron_comments_callback')) {
    function electron_comments_callback($comment, $args, $depth)
    {
        global $post;
        $GLOBALS['comment'] = $comment;
        switch ($comment->comment_type) :
            case 'pingback' :
            case 'trackback' :
                // Display trackbacks differently than normal comments.
                ?>
                <li id="comment-<?php comment_ID(); ?>" <?php comment_class(); ?>>
                <div id="comment-<?php comment_ID(); ?>" class="comment-body">
                    <div class="comment-content pingback">
                        <div class="head">
                            <?php esc_html_e('Pingback', 'electron'); ?>
                        </div>
                        <div class="comment-text">
                            <?php comment_author_link(); ?>
                        </div>
                    </div>
                </div>
                <?php
                break;
            default :
                // Proceed with normal comments.
                ?>
            <li id="comments-<?php comment_ID(); ?>" <?php comment_class($args['has_children'] ? 'parent' : '', $comment); ?>
                xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">
                <div class="comment-body">
                    <div class="content">
                        <div class="comment-author">
                            <?php if (0 != $args['avatar_size']) echo get_avatar($comment, $args['avatar_size']); ?>
                        </div>
                    </div>
                    <div class="comment-content">
                        <div class="meta">
                            <h3 class="name"><?php comment_author_link(); ?></h3>
                            <span class="comment-meta commentmetadata">
                        <span class="time">
                             <a href="<?php echo esc_url(get_comment_link($comment, $args)); ?>">
                                 <time datetime="<?php comment_time('c'); ?>">
                                     <?php
                                     /* translators: 1: comment date, 2: comment time */
                                     printf(__('%1$s @ %2$s', 'electron'), get_comment_date('', $comment), get_comment_time());
                                     ?>
                                 </time>
                             </a>
                        </span>
                        <span class="divider">-</span>
                        <span class="link">
                            <?php
                            comment_reply_link(array_merge($args, array(
                                'reply-text' => esc_html__('leave a reply', 'electron') . '<i class="la la-arrow-down"></i>',
                                'depth' => $depth,
                                'max_depth' => $args['max_depth'],
                            )));
                            ?>
                        </span>
                                <?php if ('0' == $comment->comment_approved) : ?>
                                    <em class="comment-awaiting-moderation"><?php _e('Your comment is awaiting moderation.', 'electron'); ?></em>
                                <?php endif; ?>
                    </span>
                            <!-- .comment-meta -->
                            <div class="text">
                                <?php comment_text(); ?>
                            </div>
                            <!-- .comment-content -->
                        </div>
                    </div>
                </div>
                <!-- .comment-body -->
                <?php
                break;
        endswitch; // End comment_type check.
    }
}