<?php

/**
 * Retrieve Google fonts
 */

if (!function_exists('electron_fonts_url')) {
    function electron_fonts_url()
    {
        $fonts_url = '';
        $Lato = _x('on', 'Lato font: on or off', 'electron');
        $Source = _x('on', 'Source Sans Pro font: on or off', 'electron');
        if ('off' !== $Lato || 'off' !== $Source) {
            $font_families = array();
            if ('off' !== $Lato) {
                $font_families[] = 'Lato:100,300,400,400i,700%7';
            }
            if ('off' !== $Source) {
                $font_families[] = 'Source Sans Pro:300,400,400i,600,700';
            }
            $query_args = array(
                'family' => urlencode(implode('|', $font_families)),
                'subset' => urlencode('latin,latin-ext'),
            );
            $fonts_url = add_query_arg($query_args, '"//fonts.googleapis.com/css');
        }
        return esc_url_raw($fonts_url);
    }
}


/**
 * Enqueue styles & scripts
 */
if (!function_exists('electron_enqueue')) {
    function electron_enqueue()
    {
        // enqueue css files
        wp_enqueue_style('google-font', electron_fonts_url());
        wp_enqueue_style('bootstrap-css', get_template_directory_uri() . '/css/bootstrap.min.css', array(), '1.0');
        wp_enqueue_style('font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css', array(), '1.0');
        wp_enqueue_style('font-materialdesign', get_template_directory_uri() . '/css/font-materialdesign.css', array(), '1.0');
        wp_enqueue_style('slick-css', get_template_directory_uri() . '/css/slick.css', array(), '1.0');
        wp_enqueue_style('magnific-popup-css', get_template_directory_uri() . '/css/magnific-popup.min.css', array(), '1.0');
        wp_enqueue_style('flexslider-css', get_template_directory_uri() . '/css/flexslider.css', array(), '1.0');
        wp_enqueue_style('style-css', get_template_directory_uri() . '/css/style.css', array(), '1.0');
        wp_enqueue_style('custom-css', get_template_directory_uri() . '/css/custom.css', array(), '1.0');


        // enqueue js files
        wp_enqueue_script('html5shiv_min', get_template_directory_uri() . "/js/html5shiv.min.js", array(), '1.0');
        wp_script_add_data('html5shiv_min', 'conditional', 'IE 9');
        wp_enqueue_script('respond-min', get_template_directory_uri() . "/js/respond.min.js", array(), '1.0');
        wp_script_add_data('respond-min', 'conditional', 'IE 9');

        wp_enqueue_script('bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), null, true);

        wp_enqueue_script('slick', get_template_directory_uri() . '/js/slick.js', array('jquery'), '1.0', true);
        wp_enqueue_script('flexslider', get_template_directory_uri() . '/js/jquery.flexslider-min.js', array('jquery'), '1.0', true);
        wp_enqueue_script('magnific-popup', get_template_directory_uri() . '/js/jquery.magnific-popup.min.js', array('jquery'), '1.0', true);
        wp_enqueue_script('slicknav', get_template_directory_uri() . '/js/slicknav.js', array('jquery'), '1.0', true);
        wp_enqueue_script('script', get_template_directory_uri() . '/js/script.js', array('jquery', 'masonry'), '1.0', true);


        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
    }

    add_action('wp_enqueue_scripts', 'electron_enqueue');
}


/**
 * Define content width
 */

if (!isset($content_width)) {
    $content_width = 1200;
}

/** * Function for set up theme */
add_action('after_setup_theme', 'electron_setup_theme');
if (!function_exists('electron_setup_theme')) {
    function electron_setup_theme()
    {
        add_theme_support('title-tag');
        add_theme_support( 'automatic-feed-links' );
        add_theme_support('post-thumbnails');
        add_editor_style('/css/styles.css');
        register_nav_menus(array('electron_menu' => esc_html__('Electron Menu', 'electron')));
        load_theme_textdomain('electron', get_template_directory() . '/languages');
        add_theme_support('post-formats',
            array(
                'gallery',
                'audio',
                'video',
            ));

    }
}

/** * Function for navigation */
if (!function_exists('electron_posts_link_attributes')) {
    add_filter('next_posts_link_attributes', 'electron_posts_link_attributes');
    add_filter('previous_posts_link_attributes', 'electron_posts_link_attributes');

    function electron_posts_link_attributes()
    {
        return 'class="p-older-posts"';
    }
}

/** * Function for Get widgets data */
add_action('widgets_init', 'electron_widgets_init');
if (!function_exists('electron_widgets_init')) {
    function electron_widgets_init()
    {
        register_sidebar(array(
            'name' => esc_html__('Electron Sidebar', 'electron'),
            'id' => 'electron_sidebar',
            'before_widget' => '<div class="widget">',
            'after_widget' => '</div>',
            'before_title' => '<div class="widget-title-wrapper"><div class="widget-title">',
            'after_title' => '<div class="simple-line"></div></div><div class="simple-line"></div></div>',
        ));

        register_sidebar(array(
            'name' => esc_html__('Electron Footer 1', 'electron'),
            'id' => 'electron_footer1',
            'before_widget' => '<div class="footer_widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title">',
            'after_title' => '</h3>',
        ));


        register_sidebar(array(
            'name' => esc_html__('Electron Footer 2', 'electron'),
            'id' => 'electron_footer2_text',
            'before_widget' => '<div class="footer_widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title"> ',
            'after_title' => '</h3>',
        ));

        register_sidebar(array(
            'name' => esc_html__('Electron Footer 3', 'electron'),
            'id' => 'electron_footer3_post',
            'before_widget' => '<div class="footer_widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title">',
            'after_title' => '</h3>',
        ));

    }
}

/** * Include Instagram file */
require_once get_template_directory() . '/inc/electron_insta.php';

/** * Include Twitter file */
require_once get_template_directory() . '/inc/electron_tweet.php';

/** * Include Comments file */
require_once get_template_directory() . '/inc/electron_comment.php';

/** * Include Plugins files */
require_once get_template_directory() . '/plugins/kirki/kirki.php';
require_once get_template_directory() . '/plugins/class-tgm-plugin-activation.php';
/** * Include Admin files */
require_once get_template_directory() . '/admin/customizer.php';
require_once get_template_directory() . '/admin/customcss.php';
/** * Include widgets files */
require_once get_template_directory() . '/widget/about_author_widget.php';
require_once get_template_directory() . '/widget/recent_post_sidebar.php';
require_once get_template_directory() . '/widget/electron_facebook_widget.php';
require_once get_template_directory() . '/widget/electron_twitter_widget.php';
require_once get_template_directory() . '/widget/get_connected_sidebar.php';
require_once get_template_directory() . '/widget/electron_insta_widget.php';


/** * function for plugins */
if (!function_exists('electron_register_required_plugins')) {
    add_action('tgmpa_register', 'electron_register_required_plugins');
    function electron_register_required_plugins()
    {
        $plugins = array(
            array(
                'name' => 'MailChimp for WordPress',
                'slug' => 'mailchimp-for-wp',
                'required' => false,
                'version' => '4.1.1',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => ''
            ),

            array(
                'name' => 'Vafpress Post Formats UI',
                'slug' => 'vafpress-post-formats-ui-develop',
                'source' => get_template_directory() . '/plugins/vafpress-post-formats-ui.zip',
                'required' => true,
                'version' => '1.5',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => 'Electron Social icons',
                'slug' => 'electron_social_icons',
                'source' => get_template_directory() . '/plugins/electron_social_icons.zip',
                'required' => true,
                'version' => '1.0',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            )

        );

        $config = array(
            'id' => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
            'default_path' => '',                      // Default absolute path to pre-packaged plugins.
            'menu' => 'tgmpa-install-plugins', // Menu slug.
            'parent_slug' => 'themes.php',            // Parent menu slug.
            'capability' => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
            'has_notices' => true,                    // Show admin notices or not.
            'dismissable' => true,                    // If false, a user cannot dismiss the nag message.
            'dismiss_msg' => '',                      // If 'dismissable' is false, this message will be output at top of nag.
            'is_automatic' => true,                   // Automatically activate plugins after installation or not.
            'message' => '',                      // Message to output right before the plugins table.
            'strings' => array(
                'page_title' => esc_html__('Install Required Plugins', 'electron'),
                'menu_title' => esc_html__('Install Plugins', 'electron'),
                'installing' => esc_html__('Installing Plugin: %s', 'electron'), // %s = plugin name.
                'oops' => esc_html__('Something went wrong with the plugin API.', 'electron'),
                'notice_can_install_required' => _n_noop(
                    'This theme requires the following plugin: %1$s.',
                    'This theme requires the following plugins: %1$s.',
                    'electron'
                ), // %1$s = plugin name(s).
                'notice_can_install_recommended' => _n_noop(
                    'This theme recommends the following plugin: %1$s.',
                    'This theme recommends the following plugins: %1$s.',
                    'electron'
                ), // %1$s = plugin name(s).
                'notice_cannot_install' => _n_noop(
                    'Sorry, but you do not have the correct permissions to install the %1$s plugin.',
                    'Sorry, but you do not have the correct permissions to install the %1$s plugins.',
                    'electron'
                ), // %1$s = plugin name(s).
                'notice_ask_to_update' => _n_noop(
                    'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.',
                    'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.',
                    'electron'
                ), // %1$s = plugin name(s).
                'notice_ask_to_update_maybe' => _n_noop(
                    'There is an update available for: %1$s.',
                    'There are updates available for the following plugins: %1$s.',
                    'electron'
                ), // %1$s = plugin name(s).
                'notice_cannot_update' => _n_noop(
                    'Sorry, but you do not have the correct permissions to update the %1$s plugin.',
                    'Sorry, but you do not have the correct permissions to update the %1$s plugins.',
                    'electron'
                ), // %1$s = plugin name(s).
                'notice_can_activate_required' => _n_noop(
                    'The following required plugin is currently inactive: %1$s.',
                    'The following required plugins are currently inactive: %1$s.',
                    'electron'
                ), // %1$s = plugin name(s).
                'notice_can_activate_recommended' => _n_noop(
                    'The following recommended plugin is currently inactive: %1$s.',
                    'The following recommended plugins are currently inactive: %1$s.',
                    'electron'
                ), // %1$s = plugin name(s).
                'notice_cannot_activate' => _n_noop(
                    'Sorry, but you do not have the correct permissions to activate the %1$s plugin.',
                    'Sorry, but you do not have the correct permissions to activate the %1$s plugins.',
                    'electron'
                ), // %1$s = plugin name(s).
                'install_link' => _n_noop(
                    'Begin installing plugin',
                    'Begin installing plugins',
                    'electron'
                ),
                'update_link' => _n_noop(
                    'Begin updating plugin',
                    'Begin updating plugins',
                    'electron'
                ),
                'activate_link' => _n_noop(
                    'Begin activating plugin',
                    'Begin activating plugins',
                    'electron'
                ),
                'return' => esc_html__('Return to Required Plugins Installer', 'electron'),
                'plugin_activated' => esc_html__('Plugin activated successfully.', 'electron'),
                'activated_successfully' => esc_html__('The following plugin was activated successfully:', 'electron'),
                'plugin_already_active' => esc_html__('No action taken. Plugin %1$s was already active.', 'electron'),  // %1$s = plugin name(s).
                'plugin_needs_higher_version' => esc_html__('Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'electron'),  // %1$s = plugin name(s).
                'complete' => esc_html__('All plugins installed and activated successfully. %1$s', 'electron'), // %s = dashboard link.
                'contact_admin' => esc_html__('Please contact the administrator of this site for help.', 'electron'),

                'nag_type' => 'updated', // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
            )
        );

        tgmpa($plugins, $config);
    }
}