<?php
/*
Plugin Name: Electron Social icons
Plugin URI: http://themeforest.net/user/bylancer/portfolio?ref=bylancer
Description: Display post share social icons. This plugin is supported by Electron premium theme available at Themeforest.
Version: 1.0
Author: Bylancer
Author URI: https://themeforest.net/user/bylancer?ref=bylancer
License: Themeforest Licence
Text Domain: electron-social
 */


register_activation_hook( __FILE__, 'electron_social_install' );

if(!function_exists('electron_social_install')){
    function electron_social_install(){
        $arr = array();
        $arr['electron_fb_share'] = true;
        $arr['electron_tw_share'] = true;
        $arr['electron_gp_share'] = true;
        $arr['electron_pt_share'] = true;
        $arr['electron_li_share'] = true;
        update_option('electron_social_share', $arr);
    }
}


if (!function_exists('electron_social_share')) {
    function electron_social_share()
    {
        ?>
        <?php
        $a = get_option('electron_social_share');
        if (isset($a['electron_fb_share']) && $a['electron_fb_share'] == true) {
            ?>
            <a href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>"
               title="<?php echo esc_html__('Facebook', 'electron-social'); ?>"
               onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=220,width=600');return false;">
                <i class="fa fa-facebook"></i>
            </a>
        <?php
        }
        if (isset($a['electron_tw_share']) && $a['electron_tw_share'] == true) {
            ?>
            <a href="https://twitter.com/share?url=<?php the_permalink(); ?>"
               title="<?php echo esc_html__('Twitter', 'electron-social'); ?>"
               onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=260,width=600');return false;">
                <i class="fa fa-twitter"></i>
            </a>
        <?php }
        if (isset($a['electron_gp_share']) && $a['electron_gp_share'] == true) {
            ?>
            <a href="https://plus.google.com/share?url=<?php the_permalink(); ?>"
               title="<?php echo esc_html__('Google+', 'electron-social'); ?>"
               onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
                <i class="fa fa-google-plus"></i>
            </a>
        <?php }
        if (isset($a['electron_pt_share']) && $a['electron_pt_share'] == true) {
            ?>
            <a href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php if (function_exists('the_post_thumbnail')) echo esc_url(wp_get_attachment_url(get_post_thumbnail_id())); ?>&description=<?php echo urlencode(get_the_title()); ?>"
               target="_blank"
               title="<?php echo esc_html__('Pinterest', 'electron-social'); ?>"
               onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
                <i class="fa fa-pinterest-p"></i>
            </a>
        <?php }
        if (isset($a['electron_li_share']) && $a['electron_li_share'] == true) {
            ?>
            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php echo esc_html__('linkedin', 'electron-social'); ?>&summary=<?php echo urlencode(get_the_title()); ?>&source=<?php echo urlencode(get_the_title()); ?>"
               target="_blank"
               title="<?php echo esc_html__('Linkedin', 'electron-social'); ?>"
               onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
                <i class="fa fa-linkedin"></i>
            </a>
        <?php }
        ?>
    <?php
    }
}

if (!function_exists('electron_add_menu')) {
    add_action('admin_menu', 'electron_add_menu');
    function electron_add_menu()
    {
        add_theme_page('Electron Social Icons', 'Electron Social Icons', 'manage_options', 'electron_social_menu', 'electron_icons_menu');
    }
}
if (!function_exists('electron_icons_menu')) {
    function electron_icons_menu()
    {
        if (isset($_POST['electron_submit'])) {
            $arr = array();
            if (isset($_POST['fb'])) {
                $arr['electron_fb_share'] = true;
            } else {
                $arr['electron_fb_share'] = false;
            }
            if (isset($_POST['tw'])) {
                $arr['electron_tw_share'] = true;
            } else {
                $arr['electron_tw_share'] = false;
            }
            if (isset($_POST['gp'])) {
                $arr['electron_gp_share'] = true;
            } else {
                $arr['electron_gp_share'] = false;
            }
            if (isset($_POST['pt'])) {
                $arr['electron_pt_share'] = true;
            } else {
                $arr['electron_pt_share'] = false;
            }
            if (isset($_POST['li'])) {
                $arr['electron_li_share'] = true;
            } else {
                $arr['electron_li_share'] = false;
            }
            update_option('electron_social_share', $arr);
        }

        ?>
        <div class="wrap">
            <h1><?php esc_html_e('Social Icons', 'electron-social');?></h1>
            <form method="post">
                <table class="form-table">
                    <?php $a = get_option('electron_social_share');?>
                    <tbody>
                    <tr>
                        <th scope="row"><?php esc_html_e('show facebook icon', 'electron-social'); ?></th>
                        <td><input type="checkbox"
                                   name="fb" <?php echo isset($a['electron_fb_share']) ? checked($a['electron_fb_share'], true) : '';?>>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('show twitter icon', 'electron-social'); ?></th>
                        <td><input type="checkbox"
                                   name="tw" <?php echo isset($a['electron_tw_share']) ? checked($a['electron_tw_share'], true) : '';?>>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('show google-plus icon', 'electron-social'); ?></th>
                        <td><input type="checkbox"
                                   name="gp" <?php echo isset($a['electron_gp_share']) ? checked($a['electron_gp_share'], true) : '';?>>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('show pinterest icon', 'electron-social'); ?></th>
                        <td><input type="checkbox"
                                   name="pt" <?php echo isset($a['electron_pt_share']) ? checked($a['electron_pt_share'], true) : '';?>>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('show linkdin icon', 'electron-social'); ?></th>
                        <td><input type="checkbox"
                                   name="li" <?php echo isset($a['electron_li_share']) ? checked($a['electron_li_share'], true) : '';?>>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <p class="submit">
                    <input type="submit" name="electron_submit" id="submit" class="button button-primary"
                           value="<?php esc_html_e('Submit', 'electron-social');?>">
                </p>
            </form>
        </div>
    <?php
    }
}