<?php

if (!class_exists('electron_fb_widget')) {
    class electron_fb_widget extends WP_Widget
    {

        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'electron_fb_widget',
                esc_html__('Electron FB page like widget', 'electron'),
                array('description' => esc_html__('Electron FB Page like widget',
                    'electron'),)
            );
        }

        /**
         * Front-end display of widget.
         */
        function widget($args, $instance)
        {

            $app_id = $instance['app_id'];
            $fb_url = esc_url($instance['fb_url']);

            echo $args['before_widget'];
            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', esc_html($instance['title']), $instance, $this->id_base) . $args['after_title'];
            }
            wp_enqueue_script('fbwidgetscript', get_template_directory_uri() . '/js/facebook-widget.js', array('jquery'));
            $local_variables = array('app_id' => $app_id);
            wp_localize_script('fbwidgetscript', 'fbwidgetscript', $local_variables);
            echo '<div class="comment-widget  posts-listing">
                <div id="fb-root"></div>
                <div class="fb-page" data-href="' . $fb_url . '">
                     <blockquote cite="' . $fb_url . '" class="fb-xfbml-parse-ignore"><a href="' . $fb_url . '">' . esc_html($instance['fb_title']) . '</a></blockquote></div>
                </div>
                ';
            echo $args['after_widget'];

        }

        /**
         * Back-end widget form.
         */
        function form($instance)
        {
            $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Facebook', 'electron');
            $app_id = !empty($instance['app_id']) ? $instance['app_id'] : '745616182271288';
            $fb_title = !empty($instance['fb_title']) ? $instance['fb_title'] : '';
            $fb_url = !empty($instance['fb_url']) ? $instance['fb_url'] : 'http://facebook.com/facebook';
            ?>
            <p>
                <label
                        for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'electron'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>"/>
            </p>
            <p>
                <label
                        for="<?php echo esc_attr($this->get_field_id('app_id')); ?>"><?php esc_html_e('Facebook Application Id:', 'electron'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('app_id')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('app_id')); ?>" type="text"
                       value="<?php echo esc_attr($app_id) ?>"/>
            </p>
            <p>
                <label
                        for="<?php echo esc_attr($this->get_field_id('fb_title')); ?>"><?php esc_html_e('Facebook Page Title:', 'electron'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('fb_title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('fb_title')); ?>" type="text"
                       value="<?php echo esc_attr($fb_title); ?>"/>
            </p>
            <p>
                <label
                        for="<?php echo esc_attr($this->get_field_id('fb_url')); ?>"><?php esc_html_e('Facebook Page Url:', 'electron'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('fb_url')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('fb_url')); ?>" type="text"
                       value="<?php echo esc_url($fb_url); ?>"/>
                <small>
                    <?php esc_html_e('Works with only', 'electron'); ?>
                    <a href="http://www.facebook.com/help/?faq=174987089221178" target="_blank">
                        <?php esc_html_e('Valid Facebook Pages', 'electron'); ?>
                    </a>
                </small>
            </p>
            <?php
        }

        /**
         * Sanitize widget form values as they are saved.
         */
        function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = !empty($new_instance['title']) ? strip_tags($new_instance['title']) : esc_html__('Facebook', 'electron');
            $instance['app_id'] = !empty($new_instance['app_id']) ? $new_instance['app_id'] : '745616182271288';
            $instance['fb_title'] = !empty($new_instance['fb_title']) ? strip_tags($new_instance['fb_title']) : '';
            $instance['fb_url'] = !empty($new_instance['fb_url']) ? esc_url($new_instance['fb_url']) : 'http://facebook.com/facebook';
            return $instance;
        }
    }
}

add_action('widgets_init', create_function('', 'return register_widget("electron_fb_widget");'));