<div class="no-post text-center">
    <h1 class="no-post-title">
        <span><?php esc_html_e('Nothing Found', 'electron'); ?></span>
    </h1>
    <p><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'electron'); ?></p>
    <form class="search-form" action="<?php echo esc_url( home_url() ) ?>">
        <div class="input-group">
            <input class="form-control search-input" type="text" name="s"
                   placeholder="<?php esc_html_e('Search here...', 'electron'); ?>">
            <span class="input-group-btn">
                <button type="submit" class="search-btn btn btn-default">
                    <i class="fa fa-search"></i>
                    <span class="sr-only"><?php esc_html_e('search', 'electron'); ?></span>
                </button>
            </span>
        </div>
    </form>
</div>
<div class="blog-detail related-post">
    <h4 class="title"><?php esc_html_e('Related Post', 'electron'); ?></h4>
    <div class="mb-3"></div>
    <div class="blog-list">
        <div class="row">
            <?php
            $args = array(
                'posts_per_page' => 3,
                'meta_key' => '_thumbnail_id',
            );
            $featured = new WP_Query($args);
            if ($featured->have_posts()) {
                while ($featured->have_posts()) {
                    $featured->the_post();
                    ?>
                    <div class="col-md-4">
                        <div class="blog-item">
                            <div class="blog-inner">
                                <a href="<?php the_permalink(); ?>">
                                    <div class="overlay"><i class="mdi-link-variant"></i></div>
                                    <img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>"
                                         alt="<?php the_title(); ?>"/>
                                </a>
                                <div class="title">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </div>
                                <span class="date">
                                    <a href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>">
                                         <?php the_time('M j, Y'); ?>
                                    </a>
                                </span>
                            </div>
                        </div>
                    </div>
                <?php }
            }
            wp_reset_postdata(); ?>
        </div>
    </div>
</div>