<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta http-equiv="Content-Type" content="text/html;">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0"/>
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php
    wp_head();
    ?>
</head>
<body <?php body_class(); ?>>
<!--//preloader-->
<?php if (get_theme_mod('checkbox_preloader_setting', true)) { ?>
    <div id="preloader-main">
        <div class="lds-ripple">
            <div></div>
            <div></div>
        </div>
    </div>
<?php } ?>

<div class="site">
    <header id="header">
        <div id="top_bar">
            <div class="container">
                <div id="menu-mobile"></div>
                <div id="search_button">
                    <div id="show-search">
                        <?php if (get_theme_mod('checkbox_search_setting', true)) { ?>
                            <form role="search" class="searchform" action="<?php echo esc_url( home_url() ); ?>">
                                <input type="text" placeholder="<?php esc_html_e('Search here...', 'electron'); ?>"
                                       name="s"/>
                                <button type="submit" class="search-submit"><span class="fa fa-search"></span></button>
                            </form>
                        <?php } ?>
                    </div>
                </div>
                <!-- Social icons -->
                <div id="top_social">
                    <?php if (get_theme_mod('header_icon_setting', false)) {
                        if (get_theme_mod('first_icon_type', '') != '' && get_theme_mod('first_icon_url', '') != '') { ?>
                            <a href="<?php echo esc_url(get_theme_mod('first_icon_url', '')); ?>" target="_blank">
                                <i class="fa fa-<?php echo esc_attr(get_theme_mod('first_icon_type', '')); ?>"></i>
                            </a>
                        <?php }
                        if (get_theme_mod('second_icon_type', '') != '' && get_theme_mod('second_icon_url', '') != '') { ?>
                            <a href="<?php echo esc_url(get_theme_mod('second_icon_url', '')); ?>" target="_blank">
                                <i class="fa fa-<?php echo esc_attr(get_theme_mod('second_icon_type', '')); ?>"></i>
                            </a>
                        <?php }
                        if (get_theme_mod('third_icon_type', '') != '' && get_theme_mod('third_icon_url', '') != '') { ?>
                            <a href="<?php echo esc_url(get_theme_mod('third_icon_url', '')); ?>" target="_blank">
                                <i class="fa fa-<?php echo esc_attr(get_theme_mod('third_icon_type', '')); ?>"></i>
                            </a>
                        <?php }
                        if (get_theme_mod('fourth_icon_type', '') != '' && get_theme_mod('fourth_icon_url', '') != '') { ?>
                            <a href="<?php echo esc_url(get_theme_mod('fourth_icon_url', '')); ?>" target="_blank">
                                <i class="fa fa-<?php echo esc_attr(get_theme_mod('fourth_icon_type', '')); ?>"></i>
                            </a>
                        <?php }
                        if (get_theme_mod('fifth_icon_type', '') != '' && get_theme_mod('fifth_icon_url', '') != '') { ?>
                            <a href="<?php echo esc_url(get_theme_mod('fifth_icon_url', '')); ?>" target="_blank">
                                <i class="fa fa-<?php echo esc_attr(get_theme_mod('fifth_icon_type', '')); ?>"></i>
                            </a>
                        <?php }
                        if (get_theme_mod('sixth_icon_type', '') != '' && get_theme_mod('sixth_icon_url', '') != '') { ?>
                            <a href="<?php echo esc_url(get_theme_mod('sixth_icon_url', '')); ?>" target="_blank">
                                <i class="fa fa-<?php echo esc_attr(get_theme_mod('sixth_icon_type', '')); ?>"></i>
                            </a>
                        <?php }
                        if (get_theme_mod('seventh_icon_type', '') != '' && get_theme_mod('seventh_icon_url', '') != '') { ?>
                            <a href="<?php echo esc_url(get_theme_mod('seventh_icon_url', '')); ?>" target="_blank">
                                <i class="fa fa-<?php echo esc_attr(get_theme_mod('seventh_icon_type', '')); ?>"></i>
                            </a>
                        <?php }
                    } ?>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div id="logo">
            <h1>
                <a href="<?php echo esc_url( home_url() ); ?>">
                    <?php if (!empty(get_theme_mod('header_logo', ''))) { ?>
                        <img class="logo_retina" src="<?php echo esc_url(get_theme_mod('header_logo', '')); ?>"
                             alt="<?php esc_attr(bloginfo('name')); ?>">
                    <?php } else { ?>
                        <h3><i><?php echo bloginfo('name'); ?></i></h3>
                    <?php } ?>
                </a>
            </h1>
        </div>
    </header>
    <div id="menu-bar">
        <?php
        wp_nav_menu(array(
            'menu' => 'electron_menu',
            'depth' => 3,
            'container' => false,
            'menu_class' => 'menu sub-menu',
            'menu_id' => 'menu-primary-menu'
        ));
        ?>
    </div>