<?php

if (!class_exists('electron_connection_sidebar_widget')) {
    class electron_connection_sidebar_widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'electron_connection_widget',
                esc_html__('Electron Follow Us', 'electron'),
                array('description' => esc_html__('Show the Follow Us Icons',
                    'electron'),)
            );


            /**
             * Front-end display of widget.
             */
        }

        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', esc_html($instance['title']), $instance, $this->id_base) . $args['after_title'];
            } ?>

            <div class="widget-social text-center">
                <?php if (!empty($instance['fb'])) { ?>
                    <a href="<?php echo esc_url($instance['fb']); ?>" target="_blank"
                       title="<?php esc_html_e('Facebook', 'electron'); ?>"><i class="fa fa-facebook"></i></a>
                <?php } ?>
                <?php if (!empty($instance['tw'])) { ?>
                    <a href="<?php echo esc_url($instance['tw']); ?>" target="_blank"
                       title="<?php esc_html_e('Twitter', 'electron'); ?>"><i
                                class="fa fa-twitter"></i></a>
                <?php } ?>
                <?php if (!empty($instance['gp'])) { ?>
                    <a href="<?php echo esc_url($instance['gp']); ?>" target="_blank"
                       title="<?php esc_html_e('Google+', 'electron'); ?>"><i
                                class="fa fa-google-plus"></i></a>
                <?php } ?>
                <?php if (!empty($instance['li'])) { ?>
                    <a href="<?php echo esc_url($instance['li']); ?>" target="_blank"
                       title="<?php esc_html_e('Linkedin', 'electron'); ?>"><i class="fa fa-linkedin"></i></a>
                <?php } ?>
                <?php if (!empty($instance['pt'])) { ?>
                    <a href="<?php echo esc_url($instance['pt']); ?>" target="_blank"
                       title="<?php esc_html_e('Pinterest', 'electron'); ?>"><i class="fa fa-pinterest-p"></i></a>
                <?php } ?>
                <?php if (!empty($instance['yt'])) { ?>
                    <a href="<?php echo esc_url($instance['yt']); ?>" target="_blank"
                       title="<?php esc_html_e('Youtube', 'electron'); ?>"><i
                                class="fa fa-youtube-play"></i></a>
                <?php } ?>
                <?php if (!empty($instance['ig'])) { ?>
                    <a href="<?php echo esc_url($instance['ig']); ?>" target="_blank"
                       title="<?php esc_html_e('Instagram', 'electron'); ?>"><i class="fa fa-instagram"></i></a>
                <?php } ?>

            </div>

            <?php
            echo $args['after_widget'];

        }


        /**
         * Back-end widget form.
         */
        public function form($instance)
        {
            $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Get Connected', 'electron');

            $fb = !empty($instance['fb']) ? $instance['fb'] : '';
            $tw = !empty($instance['tw']) ? $instance['tw'] : '';
            $gp = !empty($instance['gp']) ? $instance['gp'] : '';
            $li = !empty($instance['li']) ? $instance['li'] : '';
            $pt = !empty($instance['pt']) ? $instance['pt'] : '';
            $yt = !empty($instance['yt']) ? $instance['yt'] : '';
            $ig = !empty($instance['ig']) ? $instance['ig'] : '';
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                    <?php esc_html_e('Title :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('fb')); ?>">
                    <?php esc_html_e('Facebook :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('fb')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('fb')); ?>" type="text"
                       value="<?php echo esc_attr($fb); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('tw')); ?>">
                    <?php esc_html_e('Twitter:', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('tw')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('tw')); ?>" type="text"
                       value="<?php echo esc_attr($tw); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('gp')); ?>">
                    <?php esc_html_e('Google+ :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('gp')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('gp')); ?>" type="text"
                       value="<?php echo esc_attr($gp); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('li')); ?>">
                    <?php esc_html_e('LinkedIn:', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('li')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('li')); ?>" type="text"
                       value="<?php echo esc_attr($li); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('pt')); ?>">
                    <?php esc_html_e('Pinterest :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('pt')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('pt')); ?>" type="text"
                       value="<?php echo esc_attr($pt); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('yt')); ?>">
                    <?php esc_html_e('Youtube :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('yt')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('yt')); ?>" type="text"
                       value="<?php echo esc_attr($yt); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('ig')); ?>">
                    <?php esc_html_e('Instagram :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('ig')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('ig')); ?>" type="text"
                       value="<?php echo esc_attr($ig); ?>">
            </p>
            <?php
        }


        /**
         * Sanitize widget form values as they are saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
            $instance['fb'] = (!empty($new_instance['fb'])) ? strip_tags($new_instance['fb']) : '';
            $instance['tw'] = (!empty($new_instance['tw'])) ? strip_tags($new_instance['tw']) : '';
            $instance['gp'] = (!empty($new_instance['gp'])) ? strip_tags($new_instance['gp']) : '';
            $instance['li'] = (!empty($new_instance['li'])) ? strip_tags($new_instance['li']) : '';
            $instance['pt'] = (!empty($new_instance['pt'])) ? strip_tags($new_instance['pt']) : '';
            $instance['yt'] = (!empty($new_instance['yt'])) ? strip_tags($new_instance['yt']) : '';
            $instance['ig'] = (!empty($new_instance['ig'])) ? strip_tags($new_instance['ig']) : '';

            return $instance;
        }
    }


}
if (!function_exists('electron_connected_widget')) {
    add_action('widgets_init', 'electron_connected_widget');
    function electron_connected_widget()
    {
        register_widget("electron_connection_sidebar_widget");
    }
}