<?php

if (!class_exists('electron_about_author_post_widget')) {
    class electron_about_author_post_widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        function __construct()
        {
            parent::__construct(
                'electron_about_author_widget',
                esc_html__('Electron About Me Widget', 'electron'),
                array('description' => esc_html__('Electron About Me Widget',
                    'electron'))
            );
        }

        /**
         * Front-end display of widget.
         */
        public function widget($args, $instance)
        {
            echo $args['before_widget'];
            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', esc_html($instance['title']), $instance, $this->id_base) . $args['after_title'];
            } ?>
            <div class="widget-about text-center">
                <?php if ($instance['img1'] != "") { ?>
                    <img src="<?php echo esc_url($instance['img1']); ?>"
                         alt="<?php esc_attr($instance['img1']); ?>">
                <?php } ?>
                <div class="mb-1"></div>
                <p><?php echo esc_html($instance['a_data']); ?></p>
                <?php if ($instance['img2'] != "") { ?>
                    <div class="sign-img">
                        <img src="<?php echo esc_url($instance['img2']); ?>"
                             alt="<?php esc_attr($instance['img2']); ?>">
                    </div>
                <?php } ?>
            </div>
            <?php
            echo $args['after_widget'];
        }


        /**
         * Back-end widget form.
         */
        public function form($instance)
        {
            $title = !empty($instance['title']) ? $instance['title'] : esc_html__('About me', 'electron');
            $img1 = !empty($instance['img1']) ? $instance['img1'] : '';
            $a_data = !empty($instance['a_data']) ? $instance['a_data'] : '';
            $img2 = !empty($instance['img2']) ? $instance['img2'] : '';

            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                    <?php esc_html_e('Title :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('img1')); ?>">
                    <?php esc_html_e('Image :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('img1')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('img1')); ?>" type="text"
                       value="<?php echo esc_attr($img1); ?>">
                <span class="description"><?php _e('Upload an image from media uploader and paste the url here.', 'electron'); ?></span>
            </p>

            <p>
                <label for="<?php echo esc_attr($this->get_field_id('a_data')); ?>">
                    <?php esc_html_e('About Author :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('a_data')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('a_data')); ?>" type="text"
                       value="<?php echo esc_attr($a_data); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('img2')); ?>">
                    <?php esc_html_e('Signature :', 'electron'); ?>
                </label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('img2')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('img2')); ?>" type="text"
                       value="<?php echo esc_attr($img2); ?>">
                <span class="description"><?php _e('Upload an image from media uploader and paste the url here', 'electron'); ?></span>
            </p>

            <?php
        }


        /**
         * Sanitize widget form values as they are saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
            $instance['img1'] = (!empty($new_instance['img1'])) ? strip_tags($new_instance['img1']) : '';
            $instance['a_data'] = (!empty($new_instance['a_data'])) ? strip_tags($new_instance['a_data']) : '';
            $instance['img2'] = (!empty($new_instance['img2'])) ? strip_tags($new_instance['img2']) : '';

            return $instance;
        }
    }
}
if (!function_exists('electron_about_author_widget')) {
    add_action('widgets_init', 'electron_about_author_widget');
    function electron_about_author_widget()
    {
        register_widget("electron_about_author_post_widget");
    }
}