<?php
$username = get_theme_mod('insta_username', 'instagram');
$limit = 6;
if ($username != '') {
    ?>
    <div class="section">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 p-0">
                    <?php
                    $media_array = electron_get_instagram($username);
                    if (is_wp_error($media_array)) {
                        ?>
                        <h5 class="text-center">
                            <?php echo wp_kses_post($media_array->get_error_message()); ?>
                        </h5>
                        <?php
                    } else {
                        $media_images = array_slice($media_array['images'], 0, $limit);
                        ?>
                        <ul class="instagram">
                            <?php foreach ($media_images as $item) { ?>
                                <li class=" col-sm-2 p-0">
                                    <a target="_blank" href="<?php echo esc_url($item['link']); ?>">
                                        <div class="instagram-wrap">
                                            <div class="overlay"></div>
                                            <i class="fa fa-instagram"></i>
                                            <img src="<?php echo esc_url($item['img']); ?>"
                                                 alt="<?php esc_attr_e('Instagram image', 'electron'); ?>">
                                        </div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
}